/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.aop;

import com.alibaba.fastjson.JSON;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.mastiff.common.enums.UserActionLogEnum;
import com.beiming.odr.mastiff.common.utils.IpUtil;
import com.beiming.odr.user.api.IUserActionLogServiceApi;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.dto.UserActionLogDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.UserActionLogInsertReqDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class BrowseLogsAspect {
    long startTime = 0L;
    long endTime = 0L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowseLogsAspect.class);
    @Resource
    private IUserActionLogServiceApi iUserActionLogServiceApi;
    @Resource
    private UserServiceApi userServiceApi;

    @Pointcut(value="execution(* com.beiming.odr.mastiff.controller.CaseController.saveCaseUnsubmit(..))|| execution(* com.beiming.odr.mastiff.controller.CaseController.updateCaseUnsubmit(..))|| execution(* com.beiming.odr.mastiff.controller.CaseController.deleteCase(..))|| execution(* com.beiming.odr.mastiff.controller.CaseController.submitThenSaveCase(..))|| execution(* com.beiming.odr.mastiff.controller.LawCaseDossierController.queryDossierList(..))|| execution(* com.beiming.odr.mastiff.controller.MediationExtendController.apply(..))|| execution(* com.beiming.odr.mastiff.controller.MediationController.getMediationInfo(..))|| execution(* com.beiming.odr.mastiff.controller.CaseMeetingController.saveNewCaseMeeting(..))|| execution(* com.beiming.odr.mastiff.controller.DocumentController.sendMediationProtocolBook(..))|| execution(* com.beiming.odr.mastiff.controller.DocumentController.saveProtocolBook(..))|| execution(* com.beiming.odr.mastiff.controller.DocumentController.previewProtocolBook(..))|| execution(* com.beiming.odr.mastiff.controller.CaseController.mediateSuccess(..))|| execution(* com.beiming.odr.mastiff.controller.DocumentController.sendFinalMediationReport(..))|| execution(* com.beiming.odr.mastiff.controller.CaseController.mediateSuspend(..))|| execution(* com.beiming.odr.mastiff.controller.LawCaseDossierController.displayFileDossier(..))|| execution(* com.beiming.odr.mastiff.controller.LawCaseDossierController.submitLawDossier(..))|| execution(* com.beiming.odr.mastiff.controller.LawCaseDossierController.rejectDossier(..))|| execution(* com.beiming.odr.mastiff.controller.CaseController.assignMediator(..))|| execution(* com.beiming.odr.mastiff.controller.CaseController.editCaseDisputeInfo(..))|| execution(* com.beiming.odr.mastiff.controller.CaseController.saveCaseUser(..))|| execution(* com.beiming.odr.mastiff.controller.CaseMeetingController.inviteSendSms(..))")
    public void allMethodsInPackage() {
    }

    @Before(value="allMethodsInPackage()")
    public void beginTransaction() {
        LOGGER.info("before beginTransaction");
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String method = request.getMethod();
        String url = request.getRequestURI();
    }

    @After(value="allMethodsInPackage()")
    public void commit(JoinPoint joinPoint) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        HttpServletResponse response = attributes.getResponse();
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("X-XSS-Protection", "1; mode=block");
        response.setHeader("Content-Security-Policy", "default-src * 'unsafe-inline'");
        String url = request.getRequestURI();
        String clientIp = IpUtil.getCliectIp((HttpServletRequest)request);
        String type = request.getHeader("Ctype");
        String serviceIp = request.getRemoteAddr();
        LOGGER.info("ARGS:" + Arrays.toString(joinPoint.getArgs()));
        String userId = JWTContextUtil.getCurrentUserId();
        String currentName = JWTContextUtil.getCurrentUserName();
        DubboResult result = this.userServiceApi.getUserLoginInfo(userId);
        List userRoles = ((LoginInfoResDTO)result.getData()).getUserRoles();
        String orgName = null;
        Long orgId = null;
        if (userRoles.size() > 0 && !"COMMON".equals(((UserRoleInfoDTO)userRoles.get(0)).getRoleType())) {
            orgId = ((UserRoleInfoDTO)userRoles.get(0)).getOrganizationId();
            orgName = ((UserRoleInfoDTO)userRoles.get(0)).getOrganizationName();
            String route = this.getUri(request);
            Object[] argsList = joinPoint.getArgs();
            String params = "";
            if (argsList.length > 0) {
                params = JSON.toJSONString((Object)argsList[0]);
            }
            for (UserActionLogEnum action : UserActionLogEnum.values()) {
                if (!route.contains(action.getRoute()) || !url.equals(action.getMonitorInterface()) || !type.equals(action.getClientType())) continue;
                String content = action.getActionContent();
                String actionContent = "";
                String actionName = action.getActionName();
                String clientType = action.getClientType();
                switch (url) {
                    case "/mastiff/document/sendMediationProtocolBook": 
                    case "/mastiff/document/saveProtocolBook": {
                        Map param = (Map)JSON.parseObject((String)params, Map.class);
                        String documentType = MapUtils.getString((Map)param, (Object)"documentType");
                        String book = "MEDIATION_BOOK".equals(documentType) ? "\u8c03\u89e3\u534f\u8bae\u4e66" : ("NO_DISSENT_MEDIATION_SCHEME".equals(documentType) ? "\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848" : ("UNDISPUTED_FACT".equals(documentType) ? "\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u534f\u8bae" : "\u7ec8\u7ed3\u8c03\u89e3\u62a5\u544a"));
                        actionContent = String.format(content, book);
                        break;
                    }
                    default: {
                        actionContent = content;
                    }
                }
                UserActionLogInsertReqDTO dto = UserActionLogInsertReqDTO.builder().userId(Long.valueOf(userId)).username(currentName).actionName(actionName).actionCode(action.name()).actionContent(actionContent).actionParams(params).serviceIp(serviceIp).clientIp(clientIp).clientType(clientType).orgId(orgId).actionResult("SUCCESS").orgName(orgName).build();
                UserActionLogDTO log = new UserActionLogDTO();
                BeanUtils.copyProperties((Object)dto, (Object)log);
                DubboResult dubboResult = this.iUserActionLogServiceApi.insert(log);
            }
        }
        LOGGER.info("after commit");
    }

    @AfterReturning(returning="returnObject", pointcut="allMethodsInPackage()")
    public void afterReturning(JoinPoint joinPoint, Object returnObject) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookie.setHttpOnly(true);
            }
        }
        LOGGER.info("afterReturning");
        this.endTime = System.currentTimeMillis();
        LOGGER.info(String.valueOf(this.endTime - this.startTime));
    }

    public String getUri(HttpServletRequest request) {
        String url = request.getHeader("Referer");
        String ip = url.split("/+")[1].split(":")[0];
        String port = !url.split("/+")[1].contains(":") ? "80" : url.split("/+")[1].split(":")[1];
        String http = "http";
        String uri = "/";
        uri = url.contains("?") ? ("80".equals(port) ? url.split("[?]")[0].split("https".concat("://").concat(ip))[1] : url.split("[?]")[0].split(http.concat("://").concat(ip).concat(":").concat(port))[1]) : ("80".equals(port) ? url.split("https".concat("://").concat(ip))[1] : url.split(http.concat("://").concat(ip).concat(":").concat(port))[1]);
        return uri;
    }

    @AfterThrowing(value="allMethodsInPackage()")
    public void afterThrowing() {
        LOGGER.info("afterThrowing afterThrowing  rollback");
    }

    @Around(value="allMethodsInPackage()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        this.startTime = System.currentTimeMillis();
        try {
            LOGGER.info("\u65b9\u6cd5\u73af\u7ed5start...around");
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            LOGGER.info("\u65b9\u6cd5\u73af\u7ed5end...around");
        }
    }
}

