/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.config;

import com.beiming.framework.domain.PlatformConfig;
import com.beiming.framework.enums.PlatformEnums;
import com.beiming.framework.log.PlatformFilter;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);

    @Bean
    PlatformConfig platformConfig() {
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setPlatform(PlatformEnums.MASTIFF_API.name());
        platformConfig.setSystem("hnswodr");
        return platformConfig;
    }

    @Bean
    public FilterRegistrationBean filterRegistration() {
        log.info("init filter......");
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(this.getPlatformFilter());
        registration.addUrlPatterns(new String[]{"/mastiff/*"});
        registration.setName("platformFilter");
        return registration;
    }

    @Bean(name={"platformFilter"})
    public Filter getPlatformFilter() {
        return new PlatformFilter();
    }
}

