/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.interceptor;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.interceptor.Access;
import com.beiming.odr.referee.enums.UserRoleEnum;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AuthorityInterceptor
extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        response.setStatus(200);
        response.setContentType("application/json;charset=UTF-8");
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            Access access = method.getAnnotation(Access.class);
            if (access == null) {
                return true;
            }
            this.checkRoles(access);
        }
        return true;
    }

    private void checkRoles(Access access) {
        if (access.authorities().length > 0) {
            UserRoleEnum[] authorities = access.authorities();
            HashSet<String> authSet = new HashSet<String>();
            for (UserRoleEnum authority : authorities) {
                authSet.add(authority.name());
            }
            List roles = JWTContextUtil.getRoles();
            boolean flag = false;
            for (String role : roles) {
                if (!authSet.contains(role)) continue;
                flag = true;
                break;
            }
            AssertUtils.assertTrue((boolean)flag, (ResultCode)APIResultCodeEnums.ACCESS_DENIED, (String)APIResultCodeEnums.ACCESS_DENIED.desc());
        }
    }
}

