/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.config;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.enums.CTypeEnums;
import com.beiming.framework.enums.JWTTokenTypeEnums;
import com.beiming.framework.exception.APIBusinessException;
import com.beiming.framework.security.JWTAuthenticationToken;
import com.beiming.framework.security.JWTUtils;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.RandomValue;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.thridparty.LoginTokenResponseDTO;
import com.beiming.odr.user.api.common.utils.Java8DateUtil;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ThirdTokenGenerator {
    private static final Logger log = LoggerFactory.getLogger(ThirdTokenGenerator.class);
    @Value(value="${jwt.auth.secret}")
    private String authJwtSecret;
    @Value(value="${jwt.refresh.secret}")
    private String refreshJwtSecret;
    @Value(value="${jwt.expireMinutes.authToken}")
    private int authTokenExpireMinutes;
    @Value(value="${jwt.expireMinutes.refreshToken}")
    private int refreshTokenExpireMinutes;
    @Resource
    private JWTUtils jwtUtils;

    public LoginTokenResponseDTO generateLoginToken(LoginInfoResDTO loginInfo, String ctype) {
        Date authTokenExpireTime = Java8DateUtil.getDate((LocalDateTime)LocalDateTime.now().plusMinutes(this.authTokenExpireMinutes));
        AppNameContextHolder.setAppName((String)"hnswodr");
        Date refreshTokenExpireTime = Java8DateUtil.getDate((LocalDateTime)LocalDateTime.now().plusMinutes(this.refreshTokenExpireMinutes));
        UserInfoDTO userInfo = loginInfo.getUserInfo();
        List<String> roles = new ArrayList();
        if (loginInfo.getUserRoles() != null) {
            for (UserRoleInfoDTO userRoleInfoDTO : loginInfo.getUserRoles()) {
                roles.add(userRoleInfoDTO.getRoleType());
            }
        }
        roles = this.sortRole(roles);
        HashMap<String, String> map = new HashMap<String, String>();
        if (CTypeEnums.ANDROID.toString().equalsIgnoreCase(ctype) || CTypeEnums.IOS.toString().equalsIgnoreCase(ctype)) {
            ctype = "APP";
        } else if (CTypeEnums.PC.toString().equalsIgnoreCase(ctype)) {
            ctype = RandomValue.getRandomCharAndNumr((Integer)10);
        }
        map.put("cType", ctype);
        String authToken = this.jwtUtils.generateJWTToken(authTokenExpireTime, userInfo.getUserId() + "", userInfo.getUserName(), userInfo.getPersonType(), roles, map, this.authJwtSecret, Long.valueOf(Long.parseLong(this.authTokenExpireMinutes + "")), TimeUnit.MINUTES, JWTTokenTypeEnums.TOKEN);
        String refreshToken = this.jwtUtils.generateJWTToken(refreshTokenExpireTime, userInfo.getUserId() + "", userInfo.getUserName(), userInfo.getPersonType(), roles, map, this.refreshJwtSecret, Long.valueOf(Long.parseLong(this.refreshTokenExpireMinutes + "")), TimeUnit.MINUTES, JWTTokenTypeEnums.REFRESH_TOKEN);
        LoginTokenResponseDTO token = new LoginTokenResponseDTO();
        token.setLoginInfo(loginInfo);
        token.setAuthToken(authToken);
        token.setRefreshToken(refreshToken);
        return token;
    }

    private JWTAuthenticationToken getJwtAuthenticationToken(String tokenStr, String jwtSecret) {
        JWTAuthenticationToken token = null;
        try {
            token = this.jwtUtils.generateAuthenticationToken(tokenStr, jwtSecret);
        }
        catch (APIBusinessException e) {
            if (APIResultCodeEnums.AUTH_TOKEN_EXPIRE.toString().equals(e.getApiResultCode().toString())) {
                AssertUtils.assertTrue((boolean)false, (ResultCode)APIResultCodeEnums.USER_NOT_LOGIN, (String)APIResultCodeEnums.USER_NOT_LOGIN.desc());
            } else {
                AssertUtils.assertTrue((boolean)false, (ResultCode)e.getApiResultCode(), (String)e.getApiResultCode().desc());
            }
        }
        catch (AssertUtils.AssertionException e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)e.getResultCode(), (String)e.getResultCode().desc());
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)e.toString());
        }
        AssertUtils.assertNotNull((Object)token, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u83b7\u53d6\u5237\u65b0token\u7684\u4fe1\u606f\u7684\u7ed3\u679c\u4e3anull");
        return token;
    }

    private List<String> sortRole(List<String> roles) {
        if (CollectionUtils.isEmpty(roles)) {
            return roles;
        }
        return roles.stream().sorted(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
    }
}

