/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.odr.mastiff.helper.ValidateMessageParser;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@ApiIgnore
public class DefaultErrorController
implements ErrorController {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorController.class);
    public static final String ERROR_PATH = "/error";
    @Resource
    private ValidateMessageParser validateMessageParser;

    @RequestMapping(value={"/error"})
    @ResponseBody
    public APIResult handleError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        String message = (String)request.getAttribute("javax.servlet.error.message");
        String requestUrl = (String)request.getAttribute("javax.servlet.error.request_uri");
        Exception exception = (Exception)request.getAttribute("javax.servlet.error.exception");
        log.error("error url :{} , http_status : {} , error_message : {} , exception {} ", new Object[]{requestUrl, statusCode, message, exception});
        if (exception != null) {
            return APIResult.failed((Exception)exception);
        }
        StringBuilder sb = new StringBuilder();
        if (statusCode != null) {
            sb.append(statusCode.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            sb.append(",").append(message);
        }
        return this.validateMessageParser.parseMessage(APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)sb.toString()));
    }

    public String getErrorPath() {
        return ERROR_PATH;
    }
}

