/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.utils.AESUtil;
import com.beiming.odr.mastiff.controller.ThirdPartyV2Controller;
import com.beiming.odr.mastiff.domain.ObjectResult;
import com.beiming.odr.mastiff.domain.dto.requestdto.GDRequest;
import com.beiming.odr.mastiff.domain.dto.requestdto.GDRequestHeader;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationYtCaseRequestV2DTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.TdhRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationCaseResponseDTO;
import com.beiming.odr.mastiff.service.thirty.tdh.PullTdhService;
import com.beiming.odr.referee.api.ThirdPartyConfigApi;
import com.beiming.odr.referee.api.ThirdPartyPullApi;
import com.beiming.odr.referee.api.ThirdPartyPushApi;
import com.beiming.odr.referee.dto.requestdto.GDEvidenceReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.CloseCaseBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.ElisorConfirmationReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.MediationDecisionReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.MediationResultReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.RetractionRegisterRequisitionReqDTO;
import com.beiming.odr.referee.dto.responsedto.ThirdPartyConfigResDTO;
import com.beiming.odr.referee.enums.SendTDHErrorEnum;
import com.beiming.odr.referee.enums.ThirdPartyInterfaceEnums;
import com.gongdao.yuncourt.security.exception.SecurityException;
import com.gongdao.yuncourt.security.util.AES;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.annotation.Resource;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mastiff/case"})
@RestController
public class ThirdPartyV2Controller {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyV2Controller.class);
    @Resource
    private ThirdPartyConfigApi thirdPartyConfigApi;
    @Resource
    private ThirdPartyPullApi thirdPartyPullApi;
    @Resource
    private ThirdPartyPushApi thirdPartyPushApi;
    @Resource
    private PullTdhService pullTdhService;
    @Value(value="${thirdparty.gongdao.appKey}")
    private String appKey;
    @Value(value="${thirdparty.gongdao.dataSecret}")
    private String dataSecret;
    @Value(value="${thirdparty.gongdao.signSercret}")
    private String signSercret;

    @ApiOperation(value="\u4fdd\u5b58\u8c03\u89e3\u6848\u4ef6", notes="\u4fdd\u5b58\u8c03\u89e3\u6848\u4ef6", response=MediationCaseResponseDTO.class)
    @PostMapping(value={"/saveYtCase"})
    public ObjectResult saveYtInfo(@RequestBody TdhRequestDTO tdhRequestDTO, @RequestHeader(value="appid") String appId) {
        AppNameContextHolder.setAppName((String)"hnswodr");
        log.info("\u5f15\u8c03\u6848\u4ef6\u5f15\u5165\u53c2:{},appId:{}", (Object)tdhRequestDTO, (Object)appId);
        DubboResult configResult = this.thirdPartyConfigApi.getConfigByAppId(appId);
        if (!configResult.isSuccess() || null == configResult.getData()) {
            return ObjectResult.error((int)SendTDHErrorEnum.SERVER_ERROR.getCode(), (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684appid");
        }
        ThirdPartyConfigResDTO data = (ThirdPartyConfigResDTO)configResult.getData();
        String appSecret = data.getAppSecret();
        String decrypt = AESUtil.decrypt((String)tdhRequestDTO.getData(), (String)appSecret);
        ObjectMapper mapper = new ObjectMapper();
        ThirdPartyInterfaceEnums code = ThirdPartyInterfaceEnums.getEnumsByCode((String)tdhRequestDTO.getType());
        if (null == code) {
            return ObjectResult.error((int)SendTDHErrorEnum.SERVER_ERROR.getCode(), (String)SendTDHErrorEnum.SERVER_ERROR.getName());
        }
        switch (1.$SwitchMap$com$beiming$odr$referee$enums$ThirdPartyInterfaceEnums[code.ordinal()]) {
            case 1: {
                try {
                    MediationYtCaseRequestV2DTO mediationYtCaseRequestV2DTO = (MediationYtCaseRequestV2DTO)mapper.readValue(decrypt, MediationYtCaseRequestV2DTO.class);
                    MediationCaseResponseDTO mediationCaseResponseDTO = this.pullTdhService.saveCase(mediationYtCaseRequestV2DTO);
                    return ObjectResult.success((Object)mediationCaseResponseDTO);
                }
                catch (Exception e) {
                    return ObjectResult.error((int)SendTDHErrorEnum.SERVER_ERROR.getCode(), (String)SendTDHErrorEnum.SERVER_ERROR.getName());
                }
            }
            case 2: {
                try {
                    ElisorConfirmationReqDTO elisorConfirmationReqDTO = (ElisorConfirmationReqDTO)mapper.readValue(decrypt, ElisorConfirmationReqDTO.class);
                    log.info("\u63a5\u6536\u53f8\u6cd5\u786e\u8ba4\u4e66\u5165\u53c2\u7ed3\u679c:{}", (Object)elisorConfirmationReqDTO);
                    DubboResult dubboResult = this.thirdPartyPullApi.saveJudgeConfirmation(elisorConfirmationReqDTO);
                    AssertUtils.assertTrue((dubboResult != null && dubboResult.isSuccess() ? 1 : 0) != 0, (ResultCode)SendTDHErrorEnum.getSendTDHErrorEnum((int)dubboResult.getCode()), (String)dubboResult.getMessage());
                    return ObjectResult.success((Object)dubboResult.getData());
                }
                catch (Exception e) {
                    return ObjectResult.error((int)SendTDHErrorEnum.SERVER_ERROR.getCode(), (String)SendTDHErrorEnum.SERVER_ERROR.getName());
                }
            }
            case 3: {
                try {
                    MediationDecisionReqDTO mediationDecisionReqDTO = (MediationDecisionReqDTO)mapper.readValue(decrypt, MediationDecisionReqDTO.class);
                    DubboResult dubboResult = this.thirdPartyPullApi.saveMediationBook(mediationDecisionReqDTO);
                    AssertUtils.assertTrue((dubboResult != null && dubboResult.isSuccess() ? 1 : 0) != 0, (ResultCode)SendTDHErrorEnum.getSendTDHErrorEnum((int)dubboResult.getCode()), (String)dubboResult.getMessage());
                    return ObjectResult.success((Object)dubboResult.getData());
                }
                catch (Exception e) {
                    return ObjectResult.error((int)SendTDHErrorEnum.SERVER_ERROR.getCode(), (String)SendTDHErrorEnum.SERVER_ERROR.getName());
                }
            }
            case 4: {
                try {
                    RetractionRegisterRequisitionReqDTO retractionRegisterRequisitionReqDTO = (RetractionRegisterRequisitionReqDTO)mapper.readValue(decrypt, RetractionRegisterRequisitionReqDTO.class);
                    DubboResult dubboResult = this.thirdPartyPullApi.saveWithdrawBook(retractionRegisterRequisitionReqDTO);
                    AssertUtils.assertTrue((dubboResult != null && dubboResult.isSuccess() ? 1 : 0) != 0, (ResultCode)SendTDHErrorEnum.getSendTDHErrorEnum((int)dubboResult.getCode()), (String)dubboResult.getMessage());
                    return ObjectResult.success((Object)dubboResult.getData());
                }
                catch (Exception e) {
                    return ObjectResult.error((int)SendTDHErrorEnum.SERVER_ERROR.getCode(), (String)SendTDHErrorEnum.SERVER_ERROR.getName());
                }
            }
            case 5: {
                try {
                    CloseCaseBookReqDTO closeCaseBookReqDTO = (CloseCaseBookReqDTO)mapper.readValue(decrypt, CloseCaseBookReqDTO.class);
                    DubboResult dubboResult = this.thirdPartyPullApi.saveCloseCaseBook(closeCaseBookReqDTO);
                    AssertUtils.assertTrue((dubboResult != null && dubboResult.isSuccess() ? 1 : 0) != 0, (ResultCode)SendTDHErrorEnum.getSendTDHErrorEnum((int)dubboResult.getCode()), (String)dubboResult.getMessage());
                    return ObjectResult.success((Object)dubboResult.getData());
                }
                catch (Exception e) {
                    return ObjectResult.error((int)SendTDHErrorEnum.SERVER_ERROR.getCode(), (String)SendTDHErrorEnum.SERVER_ERROR.getName());
                }
            }
            case 6: {
                try {
                    MediationResultReqDTO mediationResultReqDTO = (MediationResultReqDTO)mapper.readValue(decrypt, MediationResultReqDTO.class);
                    DubboResult dubboResult = this.thirdPartyPullApi.dealMediationResult(mediationResultReqDTO);
                    AssertUtils.assertTrue((dubboResult != null && dubboResult.isSuccess() ? 1 : 0) != 0, (ResultCode)SendTDHErrorEnum.getSendTDHErrorEnum((int)dubboResult.getCode()), (String)dubboResult.getMessage());
                    return ObjectResult.success((Object)dubboResult.getData());
                }
                catch (Exception e) {
                    return ObjectResult.error((int)SendTDHErrorEnum.SERVER_ERROR.getCode(), (String)SendTDHErrorEnum.SERVER_ERROR.getName());
                }
            }
        }
        return ObjectResult.error((int)SendTDHErrorEnum.SERVER_ERROR.getCode(), (String)"\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u7684type\u5f15\u8c03");
    }

    @ApiOperation(value="\u516c\u9053\u6587\u4ef6\u4e0a\u4f20", notes="\u516c\u9053\u6587\u4ef6\u4e0a\u4f20", response=MediationCaseResponseDTO.class)
    @PostMapping(value={"/gdFileUpload"})
    public APIResult gdFIleUpload(@RequestBody GDRequest request) {
        log.info("\u516c\u9053\u8bc1\u636e\u4e0a\u4f20\u5165\u53c2:{}", (Object)request);
        String requestBody = "";
        GDEvidenceReqDTO gdEvidenceReqDTO = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            GDRequestHeader requestHeader = request.getRequestHeader();
            String nonce = requestHeader.getNonce();
            requestBody = AES.decrypt128((String)request.getRequestBody(), (String)this.dataSecret, (String)requestHeader.getNonce());
            gdEvidenceReqDTO = (GDEvidenceReqDTO)mapper.readValue(requestBody, GDEvidenceReqDTO.class);
        }
        catch (SecurityException e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6d88\u606f\u4f53\u89e3\u5bc6\u5931\u6557");
        }
        catch (IOException e) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)"\u6d88\u606f\u4f53\u8f6c\u5316\u5931\u8d25");
        }
        DubboResult dubboResult = this.thirdPartyPushApi.gdEvidenceDownload(gdEvidenceReqDTO);
        if (dubboResult.isSuccess()) {
            return APIResult.success();
        }
        return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)dubboResult.getMessage());
    }
}

