/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.helper;

import com.beiming.framework.domain.APIResult;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hibernate.validator.internal.engine.messageinterpolation.InterpolationTermType;
import org.hibernate.validator.internal.engine.messageinterpolation.parser.MessageDescriptorFormatException;
import org.hibernate.validator.internal.engine.messageinterpolation.parser.TokenCollector;
import org.hibernate.validator.internal.engine.messageinterpolation.parser.TokenIterator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ValidateMessageParser {
    private static final Logger log = LoggerFactory.getLogger(ValidateMessageParser.class);
    private static final String MESSAGE_KEY_PREFIX = "{";
    private static final String MESSAGE_KEY_SUFFIX = "}";
    private static final String ERROR_CODE_KEY_PRE_FIX = "errorCode.";
    private ResourceBundleLocator userResourceBundleLocator = new PlatformResourceBundleLocator("ValidationMessages");

    private String getErrorCodeMessagekey(ErrorCode errorCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(MESSAGE_KEY_PREFIX).append(ERROR_CODE_KEY_PRE_FIX).append(errorCode.toString()).append(MESSAGE_KEY_SUFFIX);
        return sb.toString();
    }

    public APIResult parseMessage(APIResult res) {
        res.setMessage(this.parseMessage(res.getMessage()));
        return res;
    }

    public String parseMessage(String messageKey) {
        if (StringUtils.isEmpty((Object)messageKey)) {
            return messageKey;
        }
        try {
            if (messageKey.startsWith(MESSAGE_KEY_PREFIX) && messageKey.endsWith(MESSAGE_KEY_SUFFIX)) {
                Locale locale = LocaleContextHolder.getLocale();
                return this.interpolateBundleMessage(messageKey, this.userResourceBundleLocator.getResourceBundle(locale), locale, true);
            }
            return messageKey;
        }
        catch (Exception e) {
            log.error("validate message error :", (Throwable)e);
            return messageKey;
        }
    }

    public String parseMessage(ErrorCode errorCode, String messageKey) {
        if (errorCode == null) {
            return this.parseMessage(messageKey);
        }
        String realMessageKey = StringUtils.isEmpty((Object)messageKey) || errorCode.toString().equals(messageKey) ? this.getErrorCodeMessagekey(errorCode) : messageKey;
        try {
            if (realMessageKey.startsWith(MESSAGE_KEY_PREFIX) && realMessageKey.endsWith(MESSAGE_KEY_SUFFIX)) {
                Locale locale = LocaleContextHolder.getLocale();
                return this.interpolateBundleMessage(realMessageKey, this.userResourceBundleLocator.getResourceBundle(locale), locale, true);
            }
            return realMessageKey;
        }
        catch (Exception e) {
            log.error("validate message error :", (Throwable)e);
            return realMessageKey;
        }
    }

    private String interpolateBundleMessage(String message, ResourceBundle bundle, Locale locale, boolean recursive) throws MessageDescriptorFormatException {
        TokenCollector tokenCollector = new TokenCollector(message, InterpolationTermType.PARAMETER);
        TokenIterator tokenIterator = new TokenIterator(tokenCollector.getTokenList());
        while (tokenIterator.hasMoreInterpolationTerms()) {
            String term = tokenIterator.nextInterpolationTerm();
            String resolvedParameterValue = this.resolveParameter(term, bundle, locale, recursive);
            tokenIterator.replaceCurrentInterpolationTerm(resolvedParameterValue);
        }
        return tokenIterator.getInterpolatedMessage();
    }

    private String resolveParameter(String parameterName, ResourceBundle bundle, Locale locale, boolean recursive) throws MessageDescriptorFormatException {
        String parameterValue;
        try {
            if (bundle != null) {
                parameterValue = bundle.getString(this.removeCurlyBraces(parameterName));
                if (recursive) {
                    parameterValue = this.interpolateBundleMessage(parameterValue, bundle, locale, recursive);
                }
            } else {
                parameterValue = parameterName;
            }
        }
        catch (MissingResourceException e) {
            parameterValue = parameterName;
        }
        return parameterValue;
    }

    private String removeCurlyBraces(String parameter) {
        return parameter.substring(1, parameter.length() - 1);
    }
}

