/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.aspect;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.log.ActionLoggerImpl;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="execution(* com.beiming.odr.mastiff.controller..*.*(..))")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object logAll(ProceedingJoinPoint point) throws Throwable {
        Object[] args = point.getArgs();
        Object result = point.proceed();
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String responseContent = "";
        try {
            APIResult requestResult = (APIResult)result;
            responseContent = APIResultCodeEnums.SUCCESS.value() == requestResult.getCode() ? requestResult.getMessage() : requestResult.toString();
        }
        catch (Exception requestResult) {
            // empty catch block
        }
        try {
            ActionLoggerImpl actionLogger = ActionLoggerImpl.get();
            actionLogger.currentActionLog().setRequestContent(MessageFormat.format("{0}", args));
            actionLogger.currentActionLog().setResponseContent(responseContent);
            actionLogger.currentActionLog().logContext("deviceId", null == request.getHeader("deviceId") ? "" : request.getHeader("deviceId"));
            actionLogger.currentActionLog().logContext("deviceModel", null == request.getHeader("deviceModel") ? "" : request.getHeader("deviceModel"));
            actionLogger.currentActionLog().logContext("appVersion", null == request.getHeader("appVersion") ? "" : request.getHeader("appVersion"));
            actionLogger.currentActionLog().logContext("cType", null == request.getHeader("cType") ? "" : request.getHeader("cType"));
            actionLogger.currentActionLog().logContext("osVersion", null == request.getHeader("osVersion") ? "" : request.getHeader("osVersion"));
            actionLogger.currentActionLog().logContext("appName", null == request.getHeader("appName") ? "" : request.getHeader("appName"));
            actionLogger.currentActionLog().logContext("JWTToken", null == request.getHeader("JWTToken") ? "" : request.getHeader("JWTToken"));
        }
        catch (Exception e) {
            log.error("{} ActionLoggerImpl fail {}", (Object)JavaFileUtil.getMethodName(), (Object)e);
        }
        return result;
    }
}

