/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.interceptor;

import com.beiming.framework.domain.APIResultCode;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.exception.APIBusinessException;
import com.beiming.framework.util.AssertUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DubboInterceptor {
    @Around(value="execution(com.beiming.framework.domain.DubboResult com.beiming.odr.mastiff.service..*(..)) && !execution(com.beiming.framework.domain.DubboResult com.beiming.odr.mastiff.service.backend.user.impl.UserDubboServiceImpl.caseUserRegister(..))")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object res = point.proceed();
        AssertUtils.assertNotNull((Object)res, (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)"\u5185\u90e8\u7cfb\u7edf\u5f02\u5e38");
        if (res instanceof DubboResult) {
            DubboResult dubboRes = (DubboResult)res;
            if (dubboRes.isSuccess()) {
                return res;
            }
            if (dubboRes.getCode() == DubboResultCodeEnums.PARAM_ERROR.value()) {
                throw new APIBusinessException((APIResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, dubboRes.getMessage());
            }
            if (dubboRes.getCode() == DubboResultCodeEnums.SOURCE_NOT_FOUND.value()) {
                throw new APIBusinessException((APIResultCode)APIResultCodeEnums.RESULT_EMPTY, dubboRes.getMessage());
            }
            if (dubboRes.getCode() == DubboResultCodeEnums.METHOD_NOT_SUPPORTED.value()) {
                throw new APIBusinessException((APIResultCode)APIResultCodeEnums.RESULT_EMPTY, dubboRes.getMessage());
            }
            throw new APIBusinessException((APIResultCode)APIResultCodeEnums.UNEXCEPTED, dubboRes.getMessage());
        }
        return res;
    }
}

