/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.APIResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.utils.MyStringUtils;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class UserRealNameInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(UserRealNameInterceptor.class);
    @Resource
    private UserDubboService userDubboService;
    private List<String> excludeUrls = Lists.newArrayList();

    public List<String> getExcludeUrls() {
        return this.excludeUrls;
    }

    public void setExcludeUrls(List<String> excludeUrls) {
        this.excludeUrls = excludeUrls;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String requestUrl = request.getRequestURI();
        log.info("requestUrl {}", (Object)requestUrl);
        try {
            if (this.excludeUrls != null && this.excludeUrls.size() > 0) {
                for (String excludeUrl : this.excludeUrls) {
                    boolean flag = MyStringUtils.simpleWildcardMatch((String)excludeUrl, (String)requestUrl);
                    if (!flag) continue;
                    return true;
                }
            }
            response.setStatus(200);
            response.setContentType("application/json;charset=UTF-8");
            String personType = JWTContextUtil.getPersonType();
            if (PersonTypeEnum.STAFF.name().equals(personType)) {
                return true;
            }
            String userId = JWTContextUtil.getCurrentUserId();
            Boolean isRealName = this.userDubboService.isRealName(Long.valueOf(userId));
            log.debug("UserRealNameInterceptor userId {} isRealName {}", (Object)Long.valueOf(userId), (Object)isRealName);
            if (!isRealName.booleanValue()) {
                response.getWriter().print(JSONObject.toJSONString((Object)APIResult.failed((APIResultCode)ErrorCode.USER_NOT_REAL_NAME, (String)"\u8bf7\u5148\u5b9e\u540d")));
                return false;
            }
        }
        catch (Exception e) {
            log.error("UserRealNameInterceptor error", (Throwable)e);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse httpServletResponse, Object handler, ModelAndView modelAndView) throws Exception {
        log.info("postHandle......");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
        if (e != null) {
            // empty if block
        }
    }
}

