/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.SexUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.domain.dto.requestdto.GetMediationApplyBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.JudicialConfirmPersonnelRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveMediationApplyBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationApplyBookResponseDTO;
import com.beiming.odr.mastiff.service.client.MediationApplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mastiff/mediationApply"})
@Api(value="\u8c03\u89e3\u7533\u8bf7\u4e66controller", tags={"\u8c03\u89e3\u7533\u8bf7\u4e66controller"})
@RestController
public class MediationApplyController {
    @Resource
    private MediationApplyService mediationApplyService;

    @ApiOperation(value="\u83b7\u53d6\u8c03\u89e3\u7533\u8bf7\u4e66", notes="\u83b7\u53d6\u8c03\u89e3\u7533\u8bf7\u4e66", response=MediationApplyBookResponseDTO.class)
    @RequestMapping(value={"/getMediationApplyBook"}, method={RequestMethod.POST})
    public APIResult getMediationApplyBook(@RequestBody @Valid GetMediationApplyBookRequestDTO dto) {
        MediationApplyBookResponseDTO mediationApplyBook = this.mediationApplyService.getMediationApplyBook(dto);
        return APIResult.success((Object)mediationApplyBook);
    }

    @ApiOperation(value="\u4fdd\u5b58\u8c03\u89e3\u7533\u8bf7\u4e66", notes="\u4fdd\u5b58\u8c03\u89e3\u7533\u8bf7\u4e66", response=MediationApplyBookResponseDTO.class)
    @RequestMapping(value={"/saveMediationApplyBook"}, method={RequestMethod.POST})
    public APIResult saveMediationApplyBook(@RequestBody @Valid SaveMediationApplyBookRequestDTO dto) {
        MediationApplyBookResponseDTO mediationApplyBook = this.mediationApplyService.saveMediationApplyBook(dto);
        return APIResult.success((Object)mediationApplyBook);
    }

    @ApiOperation(value="\u53d1\u9001\u8c03\u89e3\u7533\u8bf7\u4e66", notes="\u53d1\u9001\u8c03\u89e3\u7533\u8bf7\u4e66", response=Long.class)
    @RequestMapping(value={"/sendMediationApplyBook"}, method={RequestMethod.POST})
    public APIResult sendMediationApplyBook(@RequestBody @Valid SaveMediationApplyBookRequestDTO dto) {
        Long mediationId = this.mediationApplyService.sendMediationApplyBook(dto);
        return APIResult.success((Object)mediationId);
    }

    private void checkSex(List<JudicialConfirmPersonnelRequestDTO> personnelList) {
        for (JudicialConfirmPersonnelRequestDTO req : personnelList) {
            if (StringUtils.isNotBlank((CharSequence)req.getIdCard()) && req.getSex() != null) {
                AssertUtils.assertTrue((boolean)SexUtils.checkSex((String)req.getSex().name(), (String)req.getIdCard()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + req.getName() + "\u4fe1\u606f\u4e2d\u6027\u522b\u4e0e\u8eab\u4efd\u8bc1\u4e0d\u7b26"));
            }
            if (!StringUtils.isNotBlank((CharSequence)req.getAgentIdCard()) || req.getAgentSex() == null) continue;
            AssertUtils.assertTrue((boolean)SexUtils.checkSex((String)req.getSex().name(), (String)req.getIdCard()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + req.getName() + "\u4fe1\u606f\u4e2d\u6027\u522b\u4e0e\u8eab\u4efd\u8bc1\u4e0d\u7b26"));
        }
    }
}

