/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.basic.storage.api.FileStorageApi;
import com.beiming.basic.storage.api.dto.response.FileInfoResponseDTO;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CasePersonRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationDownloadRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationInfoRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationDocumentResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationInfoResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationMeetingResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationProgressResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.WorkbenchDocStatusResponseDTO;
import com.beiming.odr.mastiff.service.client.LawCaseDossierService;
import com.beiming.odr.mastiff.service.client.MediationMeetingService;
import com.beiming.odr.mastiff.service.client.MediationService;
import com.beiming.odr.mastiff.utils.TranslateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.io.FileUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u8c03\u89e3\u4fe1\u606f\u67e5\u8be2controller", tags={"\u8c03\u89e3\u4fe1\u606f\u67e5\u8be2controller"})
@RequestMapping(value={"/mastiff/mediation"})
public class MediationController {
    @Resource
    private MediationService mediationService;
    @Resource
    private MediationMeetingService mediationMeetingService;
    @Resource
    private FileStorageApi fileStorageApi;
    @Resource
    private LawCaseDossierService lawCaseDossierService;

    @ApiOperation(value="\u8c03\u89e3\u8fdb\u5ea6\u67e5\u770b\u63a5\u53e3", notes="\u8c03\u89e3\u8fdb\u5ea6\u67e5\u770b\u63a5\u53e3", response=MediationProgressResponseDTO.class, responseContainer="List")
    @RequestMapping(value={"/getMediationProgress"}, method={RequestMethod.POST}, produces={"application/json"})
    public APIResult getMediationProgress(@RequestBody @Valid MediationInfoRequestDTO reqDTO) {
        List resDTOLst = this.mediationService.getMediationProgress(reqDTO);
        return APIResult.success((Object)resDTOLst);
    }

    @ApiOperation(value="\u5355\u4e2a\u6848\u4ef6\u67e5\u8be2\u63a5\u53e3", notes="\u5355\u4e2a\u6848\u4ef6\u67e5\u8be2\u63a5\u53e3", response=MediationInfoResponseDTO.class)
    @RequestMapping(value={"/getMediationInfo"}, method={RequestMethod.POST}, produces={"application/json"})
    public APIResult getMediationInfo(@RequestBody @Valid MediationInfoRequestDTO reqDTO) {
        MediationInfoResponseDTO resDTO = this.mediationService.getMediationInfo(reqDTO);
        TranslateUtil.translateMediationInfo((MediationInfoResponseDTO)resDTO);
        TranslateUtil.translateNationality((MediationInfoResponseDTO)resDTO);
        return APIResult.success((Object)resDTO);
    }

    @ApiOperation(value="\u6848\u4ef6\u4f1a\u8bae\u8bb0\u5f55\u67e5\u8be2\u63a5\u53e3", notes="\u6848\u4ef6\u4f1a\u8bae\u8bb0\u5f55\u67e5\u8be2\u63a5\u53e3", response=MediationMeetingResponseDTO.class)
    @RequestMapping(value={"/getMediatorMeetings"}, method={RequestMethod.POST}, produces={"application/json"})
    public APIResult getMediatorMeetings(@RequestBody @Valid CaseIdRequestDTO reqDTO) {
        List resDTO = this.mediationService.getMediatorMeetings(reqDTO);
        return APIResult.success((Object)resDTO);
    }

    @ApiOperation(value="\u6848\u4ef6\u6587\u4e66\u6750\u6599\u67e5\u8be2\u63a5\u53e3", notes="\u6848\u4ef6\u6587\u4e66\u6750\u6599\u67e5\u8be2\u63a5\u53e3", response=MediationDocumentResponseDTO.class)
    @RequestMapping(value={"/getMediatorDocuments"}, method={RequestMethod.POST}, produces={"application/json"})
    public APIResult getMediatorDocuments(@RequestBody @Valid CaseIdRequestDTO reqDTO) {
        List resDTO = this.mediationService.getMediatorDocuments(reqDTO);
        return APIResult.success((Object)resDTO);
    }

    @ApiOperation(value="\u6848\u4ef6\u6587\u4e66\u5de5\u4f5c\u53f0\u67e5\u8be2\u63a5\u53e3", notes="\u6848\u4ef6\u6587\u4e66\u5de5\u4f5c\u53f0\u67e5\u8be2\u63a5\u53e3", response=WorkbenchDocStatusResponseDTO.class)
    @RequestMapping(value={"/getMediationWorkbenchs"}, method={RequestMethod.POST}, produces={"application/json"})
    public APIResult getMediationWorkbenchs(@RequestBody @Valid MediationInfoRequestDTO reqDTO) {
        List resDTO = this.mediationService.getMediationWorkbenchs(reqDTO);
        return APIResult.success((Object)resDTO);
    }

    @ApiOperation(value="\u8c03\u89e3\u4e0b\u8f7d\u6587\u4ef6\u63a5\u53e3", notes="\u8c03\u89e3\u4e0b\u8f7d\u6587\u4ef6\u63a5\u53e3", hidden=true)
    @RequestMapping(value={"/mediationDownload"}, method={RequestMethod.POST}, produces={"application/json"})
    public APIResult mediationDownload(@RequestBody @Valid MediationDownloadRequestDTO mediationDownloadRequestDTO) {
        CasePersonRequestDTO casePersonRequestDTO = new CasePersonRequestDTO();
        casePersonRequestDTO.setCaseId(mediationDownloadRequestDTO.getCaseId());
        casePersonRequestDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        String fileName = this.mediationMeetingService.queryPersonList(casePersonRequestDTO, mediationDownloadRequestDTO.getFileId());
        if (fileName != null) {
            File file = new File(this.lawCaseDossierService.getStorageRootDir() + "fileName");
            DubboResult fileInfo = this.fileStorageApi.getFileInfo(mediationDownloadRequestDTO.getFileId());
            FileInfoResponseDTO data = (FileInfoResponseDTO)fileInfo.getData();
            try {
                FileUtils.writeByteArrayToFile((File)file, (byte[])data.getFileByte());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

