/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.SexUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseProtocolPersonnelRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DocumentConfirmRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.ProtocolBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SavePromiseBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveProtocolBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SendFinalMediationReportRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.ProtocolBookResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.SendProtocolBookResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.UnanimityMediationSchemeResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.LawCasePersonnelService;
import com.beiming.odr.mastiff.service.client.DocumentService;
import com.beiming.odr.referee.dto.requestdto.InvalidDocumentDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mastiff/document"})
@RestController
@Api(value="\u6587\u4e66controller", tags={"\u6587\u4e66controller"})
public class DocumentController {
    @Resource
    private DocumentService documentService;
    @Resource
    private LawCasePersonnelService lawCasePersonnelService;

    @ApiOperation(value="\u83b7\u53d6\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)", notes="\u83b7\u53d6\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)", response=ProtocolBookResponseDTO.class)
    @RequestMapping(value={"/getProtocolBook"}, method={RequestMethod.POST})
    public APIResult getProtocolBook(@Valid @RequestBody ProtocolBookRequestDTO dto) {
        ProtocolBookResponseDTO protocolBook = this.documentService.getProtocolBook(dto);
        return APIResult.success((Object)protocolBook);
    }

    @ApiOperation(value="\u4fdd\u5b58\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)", notes="\u4fdd\u5b58\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)", response=ProtocolBookResponseDTO.class)
    @RequestMapping(value={"/saveProtocolBook"}, method={RequestMethod.POST})
    public APIResult saveProtocolBook(@Valid @RequestBody SaveProtocolBookRequestDTO dto) {
        ProtocolBookResponseDTO responseDTO = this.documentService.saveProtocolBook(dto);
        return APIResult.success((Object)responseDTO);
    }

    @ApiOperation(value="\u9884\u89c8\u6587\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4) \u8fd4\u56de\u9884\u89c8\u6587\u4ef6ID", notes="\u9884\u89c8\u6587\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)")
    @GetMapping(value={"/previewProtocolBook"})
    public APIResult previewProtocolBook(@RequestParam(name="documentId") Long documentId) {
        return APIResult.success((Object)this.documentService.previewProtocolBook(documentId));
    }

    @ApiOperation(value="\u4f5c\u5e9f\u6587\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4) \u4f20\u9012\u6587\u4e66ID", notes="\u4f5c\u5e9f\u6587\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)")
    @PostMapping(value={"/invalidProtocolBook"})
    public APIResult invalidProtocolBook(@Valid @RequestBody InvalidDocumentDTO idReq) {
        this.documentService.invalidProtocolBook(idReq);
        return APIResult.success();
    }

    @ApiOperation(value="\u53d1\u9001\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)", notes="\u53d1\u9001\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4)", response=SendProtocolBookResponseDTO.class)
    @RequestMapping(value={"/sendMediationProtocolBook"}, method={RequestMethod.POST})
    public APIResult sendMediationProtocolBook(@Valid @RequestBody SaveProtocolBookRequestDTO dto) {
        SendProtocolBookResponseDTO responseDTO = this.documentService.sendProtocolBook(dto);
        return APIResult.success((Object)responseDTO);
    }

    @ApiOperation(value="\u540c\u610f\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u3001\u627f\u8bfa\u4e66)", notes="\u540c\u610f\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u3001\u627f\u8bfa\u4e66)", response=String.class)
    @RequestMapping(value={"/agreeProtocolBook"}, method={RequestMethod.POST})
    public APIResult agreeProtocolBook(@Valid @RequestBody DocumentConfirmRequestDTO dto) {
        String launchSign = this.documentService.launchSign(dto.getDocumentId(), JWTContextUtil.getCurrentUserId());
        return APIResult.success((Object)launchSign);
    }

    @ApiOperation(value="\u62d2\u7edd\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u3001\u627f\u8bfa\u4e66)", notes="\u62d2\u7edd\u534f\u8bae\u4e66(\u8c03\u89e3\u534f\u8bae\u3001\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u3001\u65e0\u4e89\u8bae\u4e8b\u5b9e\u786e\u8ba4\u3001\u627f\u8bfa\u4e66)", response=Long.class)
    @RequestMapping(value={"/refuseProtocolBook"}, method={RequestMethod.POST})
    public APIResult refuseProtocolBook(@Valid @RequestBody DocumentConfirmRequestDTO dto) {
        Long docId = this.documentService.refuserProtocolBook(dto.getDocumentId());
        return APIResult.success((Object)docId);
    }

    @ApiOperation(value="\u8c03\u89e3\u5458\u83b7\u53d6\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848", notes="\u8c03\u89e3\u5458\u83b7\u53d6\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848", response=UnanimityMediationSchemeResponseDTO.class)
    @RequestMapping(value={"/getMediationScheme"}, method={RequestMethod.POST})
    public APIResult getMediationScheme(@Valid @RequestBody CaseIdRequestDTO dto) {
        UnanimityMediationSchemeResponseDTO result = this.documentService.getMediationScheme(dto);
        return APIResult.success((Object)result);
    }

    @ApiOperation(value="\u4fdd\u5b58\u627f\u8bfa\u4e66", notes="\u4fdd\u5b58\u627f\u8bfa\u4e66")
    @RequestMapping(value={"/savePromise"}, method={RequestMethod.POST})
    public APIResult savePromise(@Valid @RequestBody SavePromiseBookRequestDTO dto) {
        this.documentService.savePromiseBook(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u53d1\u9001\u7ec8\u7ed3\u8c03\u89e3\u62a5\u544a", notes="\u53d1\u9001\u7ec8\u7ed3\u8c03\u89e3\u62a5\u544a")
    @RequestMapping(value={"/sendFinalMediationReport"}, method={RequestMethod.POST})
    public APIResult sendFinalMediationReport(@Valid @RequestBody SendFinalMediationReportRequestDTO dto) {
        this.documentService.sendFinalMediationReport(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u7ed9\u5f53\u4e8b\u4eba\u4fee\u6539\u81ea\u5df1\u4fe1\u606f", notes="\u65e0\u5f02\u8bae\u8c03\u89e3\u65b9\u6848\u7ed9\u5f53\u4e8b\u4eba\u4fee\u6539\u81ea\u5df1\u4fe1\u606f")
    @RequestMapping(value={"/updatePartyData"}, method={RequestMethod.POST})
    public APIResult updatePartyData(@Valid @RequestBody CaseProtocolPersonnelRequestDTO dto) {
        this.lawCasePersonnelService.updatePartyData(dto);
        return APIResult.success();
    }

    private void checkSex(List<CaseProtocolPersonnelRequestDTO> applicantList, List<CaseProtocolPersonnelRequestDTO> respondentList) {
        for (CaseProtocolPersonnelRequestDTO apply : applicantList) {
            if (!StringUtils.isNotBlank((CharSequence)apply.getIdCard()) || apply.getSex() == null) continue;
            AssertUtils.assertTrue((boolean)SexUtils.checkSex((String)apply.getSex().name(), (String)apply.getIdCard()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + apply.getName() + "\u4fe1\u606f\u4e2d\u6027\u522b\u4e0e\u8eab\u4efd\u8bc1\u4e0d\u7b26"));
        }
        for (CaseProtocolPersonnelRequestDTO respondent : respondentList) {
            if (!StringUtils.isNotBlank((CharSequence)respondent.getIdCard()) || respondent.getSex() == null) continue;
            AssertUtils.assertTrue((boolean)SexUtils.checkSex((String)respondent.getSex().name(), (String)respondent.getIdCard()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + respondent.getName() + "\u4fe1\u606f\u4e2d\u6027\u522b\u4e0e\u8eab\u4efd\u8bc1\u4e0d\u7b26"));
        }
    }
}

