/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.odr.mastiff.domain.dto.requestdto.EvaluateCallBackRequestDTO;
import com.beiming.odr.mastiff.service.client.EvaluateService;
import com.beiming.odr.referee.dto.requestdto.EvaluateApplyReqDTO;
import com.beiming.odr.referee.dto.requestdto.EvaluateListReqDTO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mastiff/evaluate"})
@RestController
public class EvaluateController {
    private static final Logger log = LoggerFactory.getLogger(EvaluateController.class);
    @Resource
    private EvaluateService evaluateService;

    @PostMapping(value={"/saveEvaluateReport"})
    public void saveEvaluateReport(@RequestBody EvaluateCallBackRequestDTO dto) {
        log.info("\u6613\u5224\u8bc4\u4f30\u62a5\u544a\u56de\u8c03:{}", (Object)dto);
        this.evaluateService.callBack(dto);
    }

    @PostMapping(value={"/applyEvaluateReport"})
    public APIResult applyEvaluateReport(@RequestBody EvaluateApplyReqDTO dto) {
        return this.evaluateService.saveEvaluate(dto);
    }

    @PostMapping(value={"/getEvaluateList"})
    public APIResult getEvaluateList(@RequestBody EvaluateListReqDTO req) {
        return this.evaluateService.selectEvaluateList(req);
    }
}

