/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.SexUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.domain.dto.requestdto.GetJudicialConfirmBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.JudicialConfirmPersonnelRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveJudicialConfirmBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.JudicialConfirmBookResponseDTO;
import com.beiming.odr.mastiff.service.client.JudicialConfirmService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mastiff/judicialConfirm"})
@Api(value="\u53f8\u6cd5\u786e\u8ba4controller", tags={"\u53f8\u6cd5\u786e\u8ba4controller"})
@RestController
public class JudicialConfirmController {
    @Resource
    private JudicialConfirmService judicialConfirmService;

    @ApiOperation(value="\u83b7\u53d6\u53f8\u6cd5\u786e\u8ba4\u7533\u8bf7\u4e66", notes="\u83b7\u53d6\u53f8\u6cd5\u786e\u8ba4\u7533\u8bf7\u4e66", response=JudicialConfirmBookResponseDTO.class)
    @RequestMapping(value={"/getJudicialConfirmBook"}, method={RequestMethod.POST})
    public APIResult getJudicialConfirmBook(@RequestBody @Valid GetJudicialConfirmBookRequestDTO dto) {
        JudicialConfirmBookResponseDTO judicialConfirmBook = this.judicialConfirmService.getJudicialConfirmBook(dto);
        return APIResult.success((Object)judicialConfirmBook);
    }

    @ApiOperation(value="\u4fdd\u5b58\u53f8\u6cd5\u786e\u8ba4\u7533\u8bf7\u4e66", notes="\u4fdd\u5b58\u53f8\u6cd5\u786e\u8ba4\u7533\u8bf7\u4e66", response=JudicialConfirmBookResponseDTO.class)
    @RequestMapping(value={"/saveJudicialConfirmBook"}, method={RequestMethod.POST})
    public APIResult saveJudicialConfirmBook(@RequestBody @Valid SaveJudicialConfirmBookRequestDTO dto) {
        JudicialConfirmBookResponseDTO judicialConfirmBook = this.judicialConfirmService.saveJudicialConfirmBook(dto);
        return APIResult.success((Object)judicialConfirmBook);
    }

    @ApiOperation(value="\u53d1\u9001\u53f8\u6cd5\u786e\u8ba4\u7533\u8bf7\u4e66", notes="\u53d1\u9001\u53f8\u6cd5\u786e\u8ba4\u7533\u8bf7\u4e66", response=Long.class)
    @RequestMapping(value={"/sendJudicialConfirmBook"}, method={RequestMethod.POST})
    public APIResult sendJudicialConfirmBook(@RequestBody @Valid SaveJudicialConfirmBookRequestDTO dto) {
        Long judicialId = this.judicialConfirmService.sendJudicialConfirmBook(dto);
        return APIResult.success((Object)judicialId);
    }

    private void checkSex(List<JudicialConfirmPersonnelRequestDTO> personnelList) {
        for (JudicialConfirmPersonnelRequestDTO req : personnelList) {
            if (StringUtils.isNotBlank((CharSequence)req.getIdCard()) && req.getSex() != null) {
                AssertUtils.assertTrue((boolean)SexUtils.checkSex((String)req.getSex().name(), (String)req.getIdCard()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + req.getName() + "\u4fe1\u606f\u4e2d\u6027\u522b\u4e0e\u8eab\u4efd\u8bc1\u4e0d\u7b26"));
            }
            if (!StringUtils.isNotBlank((CharSequence)req.getAgentIdCard()) || req.getAgentSex() == null) continue;
            AssertUtils.assertTrue((boolean)SexUtils.checkSex((String)req.getSex().name(), (String)req.getIdCard()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + req.getName() + "\u4fe1\u606f\u4e2d\u6027\u522b\u4e0e\u8eab\u4efd\u8bc1\u4e0d\u7b26"));
        }
    }
}

