/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.odr.mastiff.common.enums.MastiffRedisKeyEnums;
import com.beiming.odr.mastiff.domain.dto.requestdto.SignatureMediatorRequestDTO;
import com.beiming.odr.mastiff.service.client.SignatureService;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(value="\u6587\u4e66\u7b7e\u540dcontroller", tags={"\u6587\u4e66\u7b7e\u540dcontroller"})
@RequestMapping(value={"/mastiff/signature"})
public class SignatureController {
    private static final Logger log = LoggerFactory.getLogger(SignatureController.class);
    @Resource
    private SignatureService signatureServiceImpl;
    @Resource
    private RedisService redisService;

    @ApiOperation(value="\u7b7e\u540d\u63a5\u53e3", notes="\u7b7e\u540d\u63a5\u53e3", response=String.class)
    @RequestMapping(value={"/confirmSignature"}, method={RequestMethod.POST})
    public APIResult confirmSignature(@Valid SignatureMediatorRequestDTO requestDTO, @RequestParam(value="signFile") MultipartFile signFile) {
        String docId = this.signatureServiceImpl.confirmSignature(requestDTO, signFile);
        return APIResult.success((Object)docId);
    }

    @ApiOperation(value="\u663e\u793a\u4e8c\u7ef4\u7801\u63a5\u53e3", notes="\u663e\u793a\u4e8c\u7ef4\u7801\u63a5\u53e3")
    @RequestMapping(value={"/show/{shortQrCodeUrl}"}, method={RequestMethod.GET})
    public void showQRCode(HttpServletResponse response, @PathVariable String shortQrCodeUrl) {
        try {
            ServletOutputStream out = response.getOutputStream();
            response.setHeader("Content-Type", "image/png");
            HashMap<EncodeHintType, Object> config = new HashMap<EncodeHintType, Object>();
            config.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            config.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            config.put(EncodeHintType.MARGIN, 0);
            String longUrl = (String)this.redisService.hGet((RedisKey)MastiffRedisKeyEnums.SHORT_URL, shortQrCodeUrl);
            BitMatrix bitMatrix = new MultiFormatWriter().encode(longUrl, BarcodeFormat.QR_CODE, 300, 300, config);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)out);
            log.info("\u4e8c\u7ef4\u7801\u751f\u6210\u5b8c\u6bd5\uff0c\u5df2\u7ecf\u8f93\u51fa\u5230\u9875\u9762\u4e2d\u3002");
        }
        catch (WriterException e) {
            log.error("showQRCode WriterException, {}", (Throwable)e);
        }
        catch (IOException e) {
            log.error("showQRCode IOException, {}", (Throwable)e);
        }
    }
}

