/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.helper.ValidateMessageParser;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;
import springfox.documentation.annotations.ApiIgnore;

@ControllerAdvice
@ResponseBody
@ApiIgnore
public class DefaultExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);
    @Resource
    private ValidateMessageParser validateMessageParser;
    @Resource
    private MastiffMessages mastiffMessages;

    @ExceptionHandler(value={Exception.class})
    public APIResult processException(NativeWebRequest request, Exception e) {
        log.error("exception", (Throwable)e);
        return this.validateMessageParser.parseMessage(APIResult.failed((Exception)e));
    }

    @ExceptionHandler(value={ValidationException.class})
    public APIResult processValidationException(ValidationException e) {
        log.error("validation error", (Throwable)e);
        return this.validateMessageParser.parseMessage(APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)e.getMessage()));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public APIResult processConstraintViolationException(ConstraintViolationException e) {
        StringBuilder sb = new StringBuilder();
        e.getConstraintViolations().forEach(cv -> sb.append(cv.getMessage()));
        log.error("validation error {} ", (Object)sb.toString(), (Object)e);
        return this.validateMessageParser.parseMessage(APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)sb.toString()));
    }

    @ExceptionHandler(value={BindException.class})
    public APIResult handleBindException(BindException e) {
        String message = e.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "));
        log.error("bind error {}", (Object)message, (Object)e);
        return this.validateMessageParser.parseMessage(APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)message));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public APIResult methodArgumentNotValidException(MethodArgumentNotValidException e) {
        BindingResult br = e.getBindingResult();
        String message = br.getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "));
        log.error("validation error {}", (Object)message, (Object)e);
        return this.validateMessageParser.parseMessage(APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)message));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public APIResult handleHttpMessageNotReadableException(HttpMessageNotReadableException ex) {
        log.error(" error {}", (Throwable)ex);
        return this.validateMessageParser.parseMessage(APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getParameterNotBlank()));
    }
}

