/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.mastiff.common.enums.FileTypeEnum;
import com.beiming.odr.mastiff.domain.dto.requestdto.AuthorizeProxyRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.BatchFilesRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationInfoRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MaterialTypeResponseDTO;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.client.FileService;
import com.beiming.odr.referee.api.LawCasePersonnelApi;
import com.beiming.odr.referee.api.MediationMeetingApi;
import com.beiming.odr.referee.api.RoleFileApi;
import com.beiming.odr.referee.dto.responsedto.LawCasePersonResDTO;
import com.beiming.odr.referee.dto.responsedto.RoleFileDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Api(value="\u8c03\u89e3\u6587\u4ef6\u6750\u6599\u7c7b\u578b", tags={"\u8c03\u89e3\u6587\u4ef6\u6750\u6599\u7c7b\u578b"})
@RequestMapping(value={"/mastiff/file"})
public class FileController {
    @Resource
    private FileService fileService;
    @Resource
    private RoleFileApi roleFileApi;
    @Resource
    private MediationMeetingApi mediationMeetingApi;
    @Resource
    private LawCasePersonnelApi lawCasePersonnelApi;
    @Resource
    private UserDubboService userDubboService;

    @ApiOperation(value="\u4f18\u5316\u7684\u8c03\u89e3\u6587\u4ef6\u6750\u6599\u7c7b\u578b", notes="\u4f18\u5316\u7684\u8c03\u89e3\u6587\u4ef6\u6750\u6599\u7c7b\u578b")
    @RequestMapping(value={"/materialType"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult materialType(@RequestBody @Valid MediationInfoRequestDTO reqDTO) {
        Long userId = Long.parseLong(JWTContextUtil.getCurrentUserId());
        DubboResult lawCasePersonDubboResult = this.mediationMeetingApi.personListAgent(reqDTO.getLawCaseId(), userId);
        ArrayList persons = (ArrayList)lawCasePersonDubboResult.getData();
        List agentList = persons.stream().map(LawCasePersonResDTO::getCaseUserType).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List userRoles = JWTContextUtil.getRoles();
        userRoles.addAll(agentList);
        List files = this.roleFileApi.getRoleFileInfoByTypes(userRoles);
        List fileParentTypes = files.stream().map(RoleFileDTO::getRoleFile).collect(Collectors.toList());
        List parentTypes = fileParentTypes.stream().map(s -> Arrays.asList(s.split(","))).flatMap(rf -> rf.stream()).distinct().collect(Collectors.toList());
        List fileChildTypes = files.stream().map(RoleFileDTO::getRoleFileZClass).collect(Collectors.toList());
        List childTypes = fileChildTypes.stream().map(s -> Arrays.asList(s.split(","))).flatMap(rf -> rf.stream()).distinct().collect(Collectors.toList());
        MaterialTypeResponseDTO typeInfo = this.fileService.queryMaterialTypeInfo();
        typeInfo.setMaterialTypes(typeInfo.getMaterialTypes().stream().filter(dic -> parentTypes.contains(dic.getCode())).collect(Collectors.toList()));
        typeInfo.getMaterialSubTypes().forEach((key, val) -> typeInfo.getMaterialSubTypes().put(key, val.stream().filter(dic -> childTypes.contains(dic.getCode())).collect(Collectors.toList())));
        return APIResult.success((Object)typeInfo);
    }

    @ApiOperation(value="\u591a\u6587\u4ef6\u4e0a\u4f20", notes="\u591a\u6587\u4ef6\u4e0a\u4f20")
    @RequestMapping(value={"/batchFilesUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult batchFilesUpload(@RequestBody @Valid BatchFilesRequestDTO dto) {
        dto.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        dto.setUserName(this.userDubboService.getUserNameByJWT());
        dto.setFileType(FileTypeEnum.MEDIATE_FILE.name());
        this.lawCasePersonnelApi.checkUpload(dto.getUserId(), dto.getCaseId());
        this.fileService.batchFilesUpload(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u5377\u5b97\u6750\u6599\u591a\u6587\u4ef6\u4e0a\u4f20", notes="\u5377\u5b97\u6750\u6599\u591a\u6587\u4ef6\u4e0a\u4f20")
    @RequestMapping(value={"/batchDossierFilesUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult batchDossierFilesUpload(@RequestBody @Valid BatchFilesRequestDTO dto) {
        dto.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        dto.setUserName(this.userDubboService.getUserNameByJWT());
        dto.setFileType(FileTypeEnum.DOSSIER_FILE.name());
        this.fileService.batchFilesUpload(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u4fe1\u8bbf\u4ee3\u7406\u4eba\u6388\u6743\u59d4\u6258\u4e66\u4e0a\u4f20", notes="\u4fe1\u8bbf\u4ee3\u7406\u4eba\u6388\u6743\u59d4\u6258\u4e66\u4e0a\u4f20", response=Long.class)
    @RequestMapping(value={"/uploadAuthorizeProxy"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult uploadAuthorizeProxy(@RequestBody @Valid AuthorizeProxyRequestDTO dto) {
        this.fileService.getAuthorizeProxy(dto.getCaseId(), dto.getPetitionAgentId(), null);
        dto.setCreateUser(this.userDubboService.getUserNameByJWT());
        Long id = this.fileService.uploadAuthorizeProxy(dto);
        return APIResult.success((Object)id);
    }
}

