/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller.thirdparty;

import com.alibaba.fastjson.JSONArray;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.UUIDUtils;
import com.beiming.odr.mastiff.common.enums.MastiffRedisKeyEnums;
import com.beiming.odr.mastiff.common.utils.ExtAccessAnnotation;
import com.beiming.odr.mastiff.common.utils.MastiffMsgUtils;
import com.beiming.odr.mastiff.common.utils.SHAUtil;
import com.beiming.odr.mastiff.config.ThirdTokenGenerator;
import com.beiming.odr.mastiff.domain.ObjectResult;
import com.beiming.odr.mastiff.domain.dto.DictionaryDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CertificateRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationCaseRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MaterialTypeResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationCaseResponseDTO;
import com.beiming.odr.mastiff.domain.dto.thridparty.LoginTokenResponseDTO;
import com.beiming.odr.mastiff.domain.dto.thridparty.ThirdOrganizationListRequestDTO;
import com.beiming.odr.mastiff.service.client.CaseService;
import com.beiming.odr.mastiff.service.client.FileService;
import com.beiming.odr.mastiff.service.client.ThirdPartyService;
import com.beiming.odr.mastiff.service.utils.CaseCheckHelper;
import com.beiming.odr.referee.api.DictServiceApi;
import com.beiming.odr.referee.dto.DictDTO;
import com.beiming.odr.referee.dto.requestdto.DictReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrganizationListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ServicePersonListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mastiff/thirdPartyV2"})
@RestController
public class ThirdPartyController {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyController.class);
    @Resource
    private CaseService caseService;
    @Resource
    private FileService fileService;
    @Resource
    private ThirdPartyService thirdPartyService;
    @Resource
    private RedisService redisService;
    @Resource
    private DictServiceApi dictServiceApi;
    @Resource
    private ThirdTokenGenerator thirdTokenGenerator;

    @RequestMapping(value={"getServicePersonListPageToGs"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u670d\u52a1\u4eba\u5458\u5217\u8868(\u5bf9\u63a5\u56fd\u5546\u5e73\u53f0)", notes="\u67e5\u8be2\u670d\u52a1\u4eba\u5458\u5217\u8868(\u5bf9\u63a5\u56fd\u5546\u5e73\u53f0)")
    @ExtAccessAnnotation(verifySign=false)
    public APIResult getServicePersonListPageToGs(@RequestBody ServicePersonListReqDTO servicePersonListReqDTO) {
        return APIResult.success((Object)this.thirdPartyService.getServicePersonListPageToGs(servicePersonListReqDTO));
    }

    @RequestMapping(value={"getOrganizationListToGs"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u670d\u52a1\u56e2\u961f\u5217\u8868(\u5bf9\u63a5\u56fd\u5546\u5e73\u53f0)", notes="\u67e5\u8be2\u670d\u52a1\u56e2\u961f\u5217\u8868(\u5bf9\u63a5\u56fd\u5546\u5e73\u53f0)")
    @ExtAccessAnnotation(verifySign=false)
    public APIResult getOrganizationListToGs(@RequestBody OrganizationListReqDTO organizationListReqDTO) {
        return APIResult.success((Object)this.thirdPartyService.getOrganizationListToGs(organizationListReqDTO));
    }

    @ApiOperation(value="\u83b7\u53d6token", notes="\u83b7\u53d6token", response=String.class)
    @GetMapping(value={"/getToken"})
    @ExtAccessAnnotation(verifyToken=false)
    public APIResult getToken(HttpServletRequest request) {
        String appId = request.getHeader("appid");
        StringBuffer sb = new StringBuffer();
        sb.append(appId).append(UUIDUtils.uuidWithoutSeparator());
        String token = SHAUtil.getSHA256Str((String)sb.toString());
        this.redisService.set((RedisKey)MastiffRedisKeyEnums.THIRD_PARTY_TOKEN, appId, (Object)token, 30L, TimeUnit.MINUTES);
        return APIResult.success((Object)token);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u83b7\u53d6token", notes="\u6d4b\u8bd5\u83b7\u53d6token")
    @RequestMapping(value={"/testGetToken"}, method={RequestMethod.POST})
    @ExtAccessAnnotation(verifySign=false)
    public ObjectResult testGetToken() {
        return ObjectResult.success((Object)"ok");
    }

    @ApiOperation(value="\u4fdd\u5b58\u56fd\u5546\u6848\u4ef6", notes="\u4fdd\u5b58\u8c03\u89e3\u6848\u4ef6", response=MediationCaseResponseDTO.class)
    @PostMapping(value={"/saveGsCase"})
    @ExtAccessAnnotation(verifySign=false)
    public APIResult saveGsCase(@RequestBody @Valid MediationCaseRequestDTO dto) {
        CaseCheckHelper.checkApplicantRequired((List)dto.getApplyUserList());
        CaseCheckHelper.checkRespondentRequired((List)dto.getRespondentUserList());
        MediationCaseResponseDTO responseDTO = this.caseService.saveGsCase(dto);
        return APIResult.success((Object)responseDTO);
    }

    @ApiOperation(value="\u4fdd\u5b58\u8c03\u89e3\u6848\u4ef6", notes="\u4fdd\u5b58\u8c03\u89e3\u6848\u4ef6", response=MediationCaseResponseDTO.class)
    @PostMapping(value={"/saveCase"})
    @ExtAccessAnnotation(verifySign=false)
    public APIResult saveCase(@RequestBody @Valid MediationCaseRequestDTO dto) {
        CaseCheckHelper.checkApplicantRequired((List)dto.getApplyUserList());
        CaseCheckHelper.checkRespondentRequired((List)dto.getRespondentUserList());
        MediationCaseResponseDTO responseDTO = this.caseService.saveYtCase(dto);
        return APIResult.success((Object)responseDTO);
    }

    @ApiOperation(value="\u83b7\u53d6\u6848\u4ef6\u8be6\u60c5", notes="\u83b7\u53d6\u6848\u4ef6\u8be6\u60c5")
    @GetMapping(value={"/getCaseInfo"})
    @ExtAccessAnnotation(verifySign=false)
    public APIResult getCaseInfo(@RequestParam(value="caseId") Long caseId) {
        return APIResult.success((Object)this.thirdPartyService.query(caseId));
    }

    @ApiOperation(value="\u83b7\u53d6\u673a\u6784\u5217\u8868", notes="\u83b7\u53d6\u673a\u6784\u5217\u8868")
    @PostMapping(value={"/getOrgList"})
    @ExtAccessAnnotation(verifySign=false)
    public APIResult getOrgList(@RequestBody @Valid ThirdOrganizationListRequestDTO requestDTO) {
        return APIResult.success((Object)this.thirdPartyService.getMediateOrganizationList(requestDTO));
    }

    @GetMapping(value={"/listCaseReason"})
    @ApiOperation(value="\u65b0\u7248\u6848\u7531\u63a5\u53e3", notes="\u65b0\u7248\u6848\u7531\u63a5\u53e3")
    @ExtAccessAnnotation(verifySign=false)
    public JSONArray listCaseReason() {
        return this.thirdPartyService.selectNode();
    }

    @ApiOperation(value="\u56fd\u7c4d15_GB0006\u3001\u8bc1\u4ef6\u7c7b\u578b09_00015", notes="\u4f2015_GB0006\u83b7\u53d6\u56fd\u7c4d\u3001\u4f2009_00015\u8bc1\u4ef6\u7c7b\u578b\u3002\u8fd4\u56de\u53c2\u6570\u53d6name\u5b57\u6bb5")
    @RequestMapping(value={"/getDictByPre"}, method={RequestMethod.GET})
    @ExtAccessAnnotation(verifySign=false)
    public APIResult getDictByPre(String pre) {
        DictReqDTO dictReqDTO = new DictReqDTO();
        dictReqDTO.setPre(pre);
        List byPre = this.dictServiceApi.getByPre(dictReqDTO);
        for (DictDTO item : byPre) {
            String key = "referee.gh_dict.code." + item.getCode();
            String value = MastiffMsgUtils.get((String)key);
            if (value.equals(key)) continue;
            item.setName(value);
        }
        return APIResult.success((Object)byPre);
    }

    @ApiOperation(value="\u4f18\u5316\u7684\u8c03\u89e3\u6587\u4ef6\u6750\u6599\u7c7b\u578b", notes="\u4f18\u5316\u7684\u8c03\u89e3\u6587\u4ef6\u6750\u6599\u7c7b\u578b")
    @RequestMapping(value={"/materialType"}, method={RequestMethod.POST})
    @ExtAccessAnnotation(verifySign=false)
    @ResponseBody
    public APIResult materialType() {
        MaterialTypeResponseDTO typeInfo = this.fileService.queryMaterialTypeInfo();
        MaterialTypeResponseDTO newTypeInfo = new MaterialTypeResponseDTO();
        ArrayList<DictionaryDTO> newMaterialTypes = new ArrayList<DictionaryDTO>();
        LinkedHashMap newMaterialSubTypes = new LinkedHashMap();
        for (DictionaryDTO dictionaryDTO : typeInfo.getMaterialTypes()) {
            if ("DOCUMENT_MATERIAL".equals(dictionaryDTO.getCode()) || "\u6587\u4e66\u6750\u6599".equals(dictionaryDTO.getName())) continue;
            newMaterialTypes.add(dictionaryDTO);
        }
        for (Map.Entry entry : typeInfo.getMaterialSubTypes().entrySet()) {
            if ("DOCUMENT_MATERIAL".equals(entry.getKey())) continue;
            newMaterialSubTypes.put(entry.getKey(), entry.getValue());
        }
        newTypeInfo.setMaterialTypes(newMaterialTypes);
        newTypeInfo.setMaterialSubTypes(newMaterialSubTypes);
        return APIResult.success((Object)newTypeInfo);
    }

    @ApiOperation(value="\u6d77\u5357\u56fd\u5546\u5bf9\u63a5\u767b\u5f55", notes="\u6d77\u5357\u56fd\u5546\u5bf9\u63a5\u767b\u5f55")
    @RequestMapping(value={"/obtainCertificate"}, method={RequestMethod.POST, RequestMethod.GET})
    @ExtAccessAnnotation(verifySign=false)
    @ResponseBody
    public APIResult obtainCertificate(@RequestBody CertificateRequestDTO params, HttpServletRequest request) {
        LoginInfoResDTO loginInfoResDTO = this.thirdPartyService.obtainCertificate(params.getParams(), request);
        LoginTokenResponseDTO token = this.thirdTokenGenerator.generateLoginToken(loginInfoResDTO, request.getHeader("cType"));
        String actionContent = "\u7528\u6237\u767b\u5f55\u901a\u8fc7\u624b\u673a\u53f7\u7801\u767b\u5f55\u6210\u529f";
        this.thirdPartyService.saveUserActionLog(token, actionContent, request);
        return APIResult.success((Object)token);
    }
}

