package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.AgentAuthorizeProxyReqDTO;
import com.beiming.odr.referee.dto.requestdto.AuthorizeProxyReqDTO;
import com.beiming.odr.referee.dto.requestdto.BatchFilesReqDTO;
import com.beiming.odr.referee.dto.requestdto.EvidenceOppugnReqDTO;
import com.beiming.odr.referee.dto.requestdto.GDBatchFilesReqDTO;
import javax.validation.Valid;
import org.springframework.transaction.annotation.Transactional;

/**
 * 文件 附件
 */
@Valid
public interface AttachmentApi {

  @Transactional(rollbackFor = Exception.class)
  DubboResult gdBatchSaveFile(GDBatchFilesReqDTO req);

  /**
   * 批量保存材料文件
   */
  DubboResult batchSaveFile(@Valid BatchFilesReqDTO batchFilesReqDTO);

  /**
   * 信访代理人授权委托书上传
   */
  DubboResult<Long> uploadAuthorizeProxy(AuthorizeProxyReqDTO reqDTO);

  /**
   * 获取信访代理人授权委托书
   */
  DubboResult<Boolean> getAuthorizeProxy(Long caseId, Long userId, Long personnelId);

  /**
   * 代理人授权委托书上传
   */
  DubboResult<Long> uploadAgentAuthorizeProxy(AgentAuthorizeProxyReqDTO reqDTO);

  /**
   * 获取代理人授权委托书
   */
  DubboResult<Boolean> getAgentAuthorizeProxy(Long caseId, Long personnelId, String agentType);

  /**
   * 用户发起质证
   */
  DubboResult applyEvidenceOppugn(EvidenceOppugnReqDTO evidenceOppugnReqDTO);

}
