package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.ClerkConfirmAllReqDTO;
import com.beiming.odr.referee.dto.requestdto.ClerkConfirmPerReqDTO;
import com.beiming.odr.referee.dto.responsedto.ClerkConfirmAllResDTO;
import com.beiming.odr.referee.dto.responsedto.ClerkConfirmPerResDTO;

/**
 * 文书签名状态API
 * 
 * @author DJQ 2018年6月27日
 *
 */
@Valid
public interface ClerkConfirmApi {

  /**
   * 查询某用户对调解文书的签名状态
   * 
   * @param reqDTO
   * @return
   */
  DubboResult<ClerkConfirmPerResDTO> getMediationClerkConfirm(@Valid ClerkConfirmPerReqDTO reqDTO);

  /**
   * 查询调解文书的各方签名状态
   * 
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<ClerkConfirmAllResDTO>> getAllMediationClerkConfirm(
      @Valid ClerkConfirmAllReqDTO reqDTO);

  /**
   * 校验用户签名权限
   * 
   * @param userId
   * @param documentId
   * @return
   */
  DubboResult<ClerkConfirmPerResDTO> judgeSignaturePermission(
      @Valid @NotNull(message = "{referee.paramUserIdNotBlank}") Long userId,
      @Valid @NotNull(message = "{referee.paramDocumentIdNotBlank}") Long documentId);

}
