package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.SaveJudicialConfirmBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveMediationApplyBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SavePromiseBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveProtocolBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SendFinalMediationReportReqDTO;
import com.beiming.odr.referee.dto.responsedto.JudicialConfirmBookResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationApplyBookResDTO;
import com.beiming.odr.referee.dto.responsedto.ProtocolBookResDTO;
import com.beiming.odr.referee.enums.DocumentTypeEnum;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * @Description: 文书api接口
 * @Author: caiwei
 * @Date: Created 2018-06-20
 */
@Valid
public interface DocumentApi {

  /**
   * 判断文书是否存在
   */
  DubboResult<Boolean> checkDocumentExist(Long id);

  /**
   * 获取协议书
   *
   *
   */
  DubboResult<ProtocolBookResDTO> getProtocolBook(Long caseId, DocumentTypeEnum documentTypeEnum);

  /**
   * 获取备份协议书
   */
  DubboResult<ProtocolBookResDTO> getTempProtocolBook(Long caseId,
      DocumentTypeEnum documentTypeEnum);

  /**
   * 保存协议书
   */
  DubboResult<ProtocolBookResDTO> saveProtocolBook(@Valid SaveProtocolBookReqDTO dto);

  /**
   * 保存调解笔录
   */
  DubboResult<ProtocolBookResDTO> saveRecordBook(@Valid SaveProtocolBookReqDTO dto);

  /**
   * 保存异议书
   */
  DubboResult<ProtocolBookResDTO> saveDissentBook(@Valid SaveProtocolBookReqDTO dto);

  /**
   * 发送协议书
   */
  DubboResult sendProtocolBook(Long documentId);

  /**
   * 获取调解方案
   */
  DubboResult getMediationScheme(Long caseId);

  /**
   * 保存承诺书
   */
  DubboResult savePromiseBook(SavePromiseBookReqDTO dto);

  /**
   * 拒绝文书
   */
  DubboResult<Long> refuseDocument(
      @Valid @NotNull(message = "{referee.paramDocumentIdNotBlank}") Long documentId,
      @Valid @NotNull(message = "{referee.paramUserIdNotBlank}") Long confirmUserId,
      String userName);

  /**
   * 确认文书<br>
   * 当前用户为该用户类型的最后一人时，进行业务状态处理
   */
  DubboResult<?> confirmDocument(Long documentId, Long userId, String userName, String userType);

  /**
   * 获取案件调解员id
   */
  DubboResult<Long> getMediationIdByCaseId(Long caseId);

  /**
   * 获取司法确认申请书
   */
  DubboResult<JudicialConfirmBookResDTO> getJudicialConfirmBook(Long caseId,
      DocumentTypeEnum documentTypeEnum, Integer isNew);

  /**
   * 保存司法确认申请书
   */
  DubboResult<Long> saveJudicialConfirmBook(SaveJudicialConfirmBookReqDTO dto);

  /**
   * 发送司法确认申请书
   */
  DubboResult<Long> sendJudicialConfirmBook(SaveJudicialConfirmBookReqDTO dto);

  /**
   * 根据文书id返回案件id
   */
  DubboResult<Long> getCaseIdByDocId(Long id);

  DubboResult sendFinalMediationReport(SendFinalMediationReportReqDTO reqDTO);

  /**
   * 获取调解申请书
   */
  DubboResult<MediationApplyBookResDTO> getMediationApplyBook(Long caseId,
      DocumentTypeEnum documentTypeEnum, Integer isNew);

  /**
   * 保存调解申请书
   */
  DubboResult<Long> saveMediationApplyBook(SaveMediationApplyBookReqDTO dto);

  /**
   * 发送调解申请书
   */
  DubboResult<Long> sendMediationApplyBook(SaveMediationApplyBookReqDTO dto);
}
