package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.AttachmentListReqDTO;
import com.beiming.odr.referee.dto.requestdto.DelFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdatePartyDataReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseProtocolPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.NotReadNumResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;


/**
 * 案件人员api
 *
 * @author xzy
 * @data 2018年9月25日
 */
@Valid
public interface LawCasePersonnelApi {

  /**
   * 通过案件id查询案件人员
   *
   * @param caseId
   * @return
   */
  DubboResult<ArrayList<CaseProtocolPersonnelResDTO>> getPersonList(@Valid @NotNull(
      message = "{referee.paramNotBlank}") Long caseId);

  /**
   * 判断当前用户是否有上传调解材料的权限
   * @param userId 用户id
   * @param caseId 案件id
   *
   */
  DubboResult checkUpload(@Valid @NotNull(message = "{referee.paramUserIdNotBlank}") Long userId,
      @Valid @NotNull(message = "{referee.paramCaseIdNotBlank}") Long caseId);

  /**
   * 判断当前用户是否有删除调解材料的权限
   * @param delFileReqDTO
   *
   */
  DubboResult checkDel(@Valid DelFileReqDTO delFileReqDTO);


  /**
   * 判断当前用户是否有下载调解材料的权限
   * @param attachmentListReqDTO
   */
  DubboResult checkDownload(@Valid AttachmentListReqDTO attachmentListReqDTO);

  DubboResult updatePartyData(UpdatePartyDataReqDTO reqDTO);

  /**
   * 获取人员名称id对应列表
   */
  DubboResult<ArrayList<NotReadNumResDTO>> getCasePersonNameList(Long lawCaseId);
}
