package com.beiming.odr.referee.api;

import java.util.ArrayList;
import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.responsedto.CaseMaterialResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.WorkbenchDocStatusResDTO;

/**
 * 调解附加信息API
 *
 */
@Valid
public interface MediationAdditionalInfoApi {

  DubboResult<ArrayList<CaseMaterialResDTO>> getMediationDocuments(Long lawCaseId);

  DubboResult<ArrayList<CaseMeetingListResDTO>> getMediationMeetings(Long lawCaseId, boolean isNew);

  DubboResult<ArrayList<WorkbenchDocStatusResDTO>> getMediationWorkbench(Long lawCaseId, Long userId,
      Boolean workbenchModel);

}
