package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.MediationCaseBaseDTO;
import com.beiming.odr.referee.dto.requestdto.DeleteCasePersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.EditCaseDisputeReqDTO;
import com.beiming.odr.referee.dto.requestdto.FailCancelCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.TrialDisciplineReqDTO;
import com.beiming.odr.referee.dto.responsedto.*;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import java.util.ArrayList;
import javax.validation.Valid;

/**
 * @Description: 调解案件api接口
 * @Author: caiwei
 * @Date: Created 2018-06-20
 */
@Valid
public interface MediationCaseApi {

  LawCaseResponseDTO getLawCase(long lawcaseId);

  /**
   * 根据案件id查询案件信息
   */
  DubboResult<CaseResDTO> getMediationCaseInfoById(Long caseId);

  /**
   * 根据通达海id查询案件信息
   */
  DubboResult<MediationCaseBaseDTO> getMediationByCiteCaseId(String caseId);

  /**
   * 插入案件
   */
  DubboResult<Long> insertMediationCase(@Valid MediationCaseReqDTO mediationCaseReqDTO);

  /**
   * 编辑案件纠纷信息
   */
  DubboResult editCaseDisputeInfo(EditCaseDisputeReqDTO dto);

  /**
   * 新增或者修改案件人
   */
  DubboResult<SaveCaseUserResDTO> saveOrEditCaseUser(@Valid MediationCaseUserReqDTO mediationCaseUserReqDTO);

  /**
   * 删除案件人
   */
  DubboResult deleteCasePersonnel(@Valid DeleteCasePersonnelReqDTO reqDTO);

  /**
   * 撤回调解
   */
  DubboResult<Integer> cancelLawCase(FailCancelCaseReqDTO reqDTO);
  /**
   * 取消待撤回调解提交
   */
  DubboResult<Integer> backCancelLawCase(FailCancelCaseReqDTO reqDTO);
  /**
   * 发起撤回案件申请
   */
  DubboResult<ArrayList<LawCaseCancelApplyAuditDTO>> applyOrAuditDetail(Long caseId,
      CaseStatusEnum cancelAudit);
  /**
   * 发起或者审核详情
   */
  DubboResult<Integer> startCancelLawCase(FailCancelCaseReqDTO reqDTO);

  /**
   * 获取调解案件材料
   */
  DubboResult getCaseMaterial(@Valid Long caseId);

  /**
   * 根据案件id查询案件基本信息
   */
  DubboResult<MediationCaseBaseDTO> getMediation(Long caseId);

  /**
   * 更新正式通达海流水号
   */
  DubboResult updateCaseCiteCaseFilingSeq(Long lawCaseId, String filingSeq);

  DubboResult<ArrayList<CaseChatRoomResDTO>> getChatRoomCaseList(Long userId);

  /**
   * 删除选定的未提交案件
   */
  DubboResult<Integer> deleteLawCase(Long caseId);

  /**
   * 未提交案件不需要验证参数
   */
  DubboResult<Long> insertMediationCaseUnsubmit(MediationCaseReqDTO reqDTO);

  DubboResult deleteAllCasePersonel(Long lawCaseId);


  DubboResult insertOrUpdateDiscipline(TrialDisciplineReqDTO reqDTO);

  DubboResult<TrialDisciplineReqDTO> searchDiscipline();
}
