package com.beiming.odr.referee.api;

import com.beiming.odr.referee.dto.requestdto.ListPetitionAgentMediationReqDTO;
import com.beiming.odr.referee.dto.requestdto.PetitionAgentCountReqDTO;
import com.beiming.odr.referee.dto.responsedto.ListPetitionAgentMediationResDTO;
import com.beiming.odr.referee.dto.responsedto.PetitionAgentCountResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.requestdto.MediationInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationListReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationProgressReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationStatusCountReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationCountResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationListResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationProgressResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationStatusCountResDTO;

/**
 * 调解信息API
 *
 * @author DJQ 2018年6月27日
 *
 */
@Valid
public interface MediationInfoApi {

  /**
   * 调解进度查看接口
   *
   *
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<MediationProgressResDTO>> getMediationProgress(
      @Valid MediationProgressReqDTO reqDTO);

  /**
   * 单个案件查询接口
   *
   *
   * @param reqDTO
   * @return
   */
  DubboResult<MediationInfoResDTO> getMediationInfo(@Valid MediationInfoReqDTO reqDTO,
      Boolean workbenchModel, Boolean isNew);

  /**
   * 案件列表查询接口 （如果是去掉关联的调解，被申请人不可以看详情）<br>
   *
   * @param reqDTO
   * @return
   */
  DubboResult<PageInfo<MediationListResDTO>> listMediationInfo(@Valid MediationListReqDTO reqDTO);

  /**
   * 根据useridList返回调解数量<br>
   * 调解员
   *
   * @param userIds
   * @return
   */
  DubboResult<MediationCountResDTO> countMediatorLawCaseNum(@Valid @NotNull(
      message = "{referee.paramUserIdNotBlank}") ArrayList<Long> userIds);

  /**
   * 根据userid返回全部,等待调解，正在调解的数量(list)<br>
   *
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<MediationStatusCountResDTO>> countMediatorLawCaseStatus(
      @Valid MediationStatusCountReqDTO reqDTO);

  /**
   * 统计用户案件信息 包括用户是创建人，申请人，代理人
   *
   * @param userId 用户id
   * @return 案件数量在data中
   */
  DubboResult<Long> countUserCase(
      @Valid @NotNull(message = "{referee.paramUserIdNotBlank}") Long userId);

  /**
   * 信访代理人代理案件列表
   *
   * @param reqDTO
   * @return
   */
  DubboResult<PageInfo<ListPetitionAgentMediationResDTO>> listPetitionAgentMediation(
      @Valid ListPetitionAgentMediationReqDTO reqDTO);

  /**
   * 信访代理人案件统计
   * @param reqDTO
   * @return 返回统计数据
   */
  DubboResult<PetitionAgentCountResDTO> petitionAgentCaseCount(@Valid PetitionAgentCountReqDTO reqDTO);

  /**
   * 统计调解员待调解案件
   * @param userId
   * @return
   */
  DubboResult<Long> countPendMediation(@Valid @NotNull(message = "{referee.paramUserIdNotBlank}") Long userId);


  /**
   * 统计调解员已调解案件
   * @param userId
   * @return
   */
  DubboResult<Long> countMediated(@Valid @NotNull(message = "{referee.paramUserIdNotBlank}") Long userId);
}
