package com.beiming.odr.referee.api;

import com.beiming.odr.arbitration.enums.SuitTypeEnums;
import com.beiming.odr.referee.dto.requestdto.AssignOrgReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationSuspendReqDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.CaseDeclinedReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationReallocateReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationSuccessFailReqDTO;
import com.beiming.odr.referee.dto.requestdto.ReapportionMediatorApplicationReqDTO;
import com.beiming.odr.referee.dto.requestdto.TransferMediationReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCasePersonResDTO;

/**
 * 调解
 *
 * @author qsh
 * @data 2018年7月3日
 */
@SuppressWarnings("rawtypes")
@Valid
public interface MediationMeetingApi {

  /**
   * 调解成功
   *
   * @return
   */

  DubboResult mediationSuccess(@Valid MediationSuccessFailReqDTO mediationSuccessFailReqDTO);

  /**
   * 调解失败
   *
   * @return
   */
  DubboResult mediationFail(@Valid MediationSuccessFailReqDTO mediationSuccessFailReqDTO);

  /**
   * 重新分配
   *
   * @return
   */
  DubboResult reallocate(@Valid MediationReallocateReqDTO diationReallocateReqDTO);

  /**
   * 受理
   *
   * @return
   */
  DubboResult accept(
      @Valid @NotNull(message = "{referee.paramCaseIdNotBlank}") Long caseId,
      @Valid @NotNull(message = "{referee.paramNotBlank}") Long userId,
      @Valid @NotNull(message = "{referee.paramNotBlank}") String userName);

  /**
   * 不受理
   *
   * @return
   */
  DubboResult caseDeclined(@Valid CaseDeclinedReqDTO caseDeclinedReqDTO);

  /**
   * 分配调解员申请
   *
   * @return
   */
  DubboResult reMediatorApplication(
      @Valid ReapportionMediatorApplicationReqDTO requestDTO);

  /**
   * 转移调解机构
   *
   * @param transferMediationReqDTO
   * @return
   */
  DubboResult transferMediation(@Valid TransferMediationReqDTO transferMediationReqDTO);

  /**
   * 查询案件与人员关系
   *
   * @param caseId
   * @param userId
   * @return
   */
  DubboResult<ArrayList<LawCasePersonResDTO>> personList(@Valid @NotNull(
      message = "{referee.paramNotBlank}") Long caseId, @Valid @NotNull(
      message = "{referee.paramNotBlank}") Long userId);

  /**
   * 申请诉讼，更新案件状态
   *
   * @param caseId 案件id
   * @param updateUserName 更新人名字
   */
  DubboResult goSuit(@Valid @NotNull(
      message = "{referee.paramCaseIdNotBlank}") Long caseId, @Valid @NotNull(
      message = "{referee.paramNotBlank}") String updateUserName);

  /**
   * 申请司法确认，更新案件状态
   *  @param caseId 案件id
   * @param updateUserName 更新人名字
   * @param type
   */
  DubboResult goJudicialConfirm(@Valid @NotNull(
      message = "{referee.paramCaseIdNotBlank}") Long caseId, @Valid @NotNull(
      message = "{referee.paramNotBlank}") String updateUserName, SuitTypeEnums type);

  /**
   * 小程序会议提醒单条会议
   * 
   * @param userId
   * @return
   */
  DubboResult<CaseMeetingPersonnelResDTO> queryMeetingTime(@Valid @NotNull(
      message = "{referee.paramUserIdNotBlank}") Long userId, @Valid @NotNull(
      message = "{referee.meetingStatusNull}") String meetingStatus, int minute);

  /**
   * 小程序会议提醒多条
   * 
   * @param userId
   * @return
   */
  DubboResult<ArrayList<CaseMeetingPersonnelResDTO>> queryMeetingTimeList(@Valid @NotNull(
      message = "{referee.paramUserIdNotBlank}") Long userId, @Valid @NotNull(
      message = "{referee.meetingStatusNull}") String meetingStatus, int minute);

  /**
   * 查询url路径
   * 
   * @param meetingId
   * @param caseId
   * @return
   */
  DubboResult<ArrayList<CaseMeetingPersonnelResDTO>> queryMeetingPersonnel(@Valid @NotNull(
      message = "{referee.paramMeetIdNotBlank}") Long meetingId, @Valid @NotNull(
      message = "{referee.paramUserIdNotBlank}") Long userId, @Valid @NotNull(
      message = "{referee.meetingStatusNull}") String meetingStatus);

  DubboResult<ArrayList<LawCasePersonResDTO>> personListAgent(@Valid @NotNull(
      message = "{referee.paramNotBlank}") Long caseId, @Valid @NotNull(
      message = "{referee.paramNotBlank}") Long userId);

  /**
   * 分配调解机构
   *
   * @param assignOrgReqDTO
   * @return
   */
  DubboResult assignOrg(@Valid AssignOrgReqDTO assignOrgReqDTO);

  /**
   * 调解终止
   *
   * @param mediationSuspendReqDTO
   * @return
   */
  DubboResult mediationSuspend(@Valid MediationSuspendReqDTO mediationSuspendReqDTO);


  /**
   * 获取工作人员已预约视频
   *
   * @param
   * @return
   */
  DubboResult<Integer> getCountBookedCaseMeeting(String userId);
}
