package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.DisputePlatMapStatisticsReqDTO;
import com.beiming.odr.referee.dto.requestdto.DisputeStatisticsReqDTO;
import com.beiming.odr.referee.dto.requestdto.DisputeSubjectStatisticsReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediateStatisticsReqDTO;
import com.beiming.odr.referee.dto.requestdto.OrgCaseStatisticsReqDTO;
import com.beiming.odr.referee.dto.responsedto.DisputeStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.DisputeTypeResDTO;
import com.beiming.odr.referee.dto.responsedto.DisputesSubjectStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.MediateStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.PlatMapStatisticsResDTO;
import com.beiming.odr.referee.dto.responsedto.StatisticsOrgAreaResDTO;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: chenjt
 * @Description: 报表统计
 * @Date: Created 2018-07-04 20:02
 */
public interface StatementStatisticsApi {


  /**
   * 纠纷报表统计(一个方法返回所有数据, 保留 2018-10-22后使用拆开后的)
   * @param reqDTO
   * @return
   */
  DubboResult<DisputeStatisticsResDTO> disputeStatisticsData(DisputeStatisticsReqDTO reqDTO);

  /**
   * 定时任务,取得每天的分类调解案件数量统计, 保存入库
   * @param startDate
   * @param endtDate
   * @return
   */
  DubboResult everyDayTaskStatisticsList(String startDate, String endtDate);

  //-----华丽的分割线-----------------下面接口由 disputeStatisticsData 拆开成5个接口


  /**
   * 统计纠纷总量.调解总量,及总数量
   * XXX纠纷数量统计/业务类型调解统计
   * @param reqDTO
   * @return
   */
  DubboResult<DisputeStatisticsResDTO> disputeCountAndLawCaseCount(DisputeStatisticsReqDTO reqDTO);

  /**
   * 平台地图  统计纠纷总量.调解总量,及总数量,调解案件成功数量,调解案件失败数量,诉讼案件数量,司法确认案件数量
   * @param reqDTO
   * @return
   */
  DubboResult<PlatMapStatisticsResDTO> platMapStatistics(DisputePlatMapStatisticsReqDTO reqDTO);

  /**
   * XXX纠纷数量统计/业务类型调解统计
   * XXX业务类型咨询统计
   * @param reqDTO
   * @return
   */
  DubboResult<DisputeStatisticsResDTO> disputeListAndLawCaseList(DisputeStatisticsReqDTO reqDTO);

  /**
   * XXX各区域纠纷类型统计
   * @param reqDTO
   * @return
   */
  DubboResult<DisputeStatisticsResDTO> disputeTypeAreaStatisticsList(DisputeStatisticsReqDTO reqDTO);


  /**
   * XXX各区域调解案件数量统计
   * @param reqDTO
   * @return
   */
  DubboResult<DisputeStatisticsResDTO> orgAreaStatisticsList(DisputeStatisticsReqDTO reqDTO);


  /**
   * 机构的纠纷调解数量(2018-11-07)
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<StatisticsOrgAreaResDTO>> queryOrgCaseCount(OrgCaseStatisticsReqDTO reqDTO);

  /**
   * 纠纷类型(需要按最近一个月使用次数排序)(2018-11-07)
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<DisputeTypeResDTO>> queryDisputeTypeCount(DisputeSubjectStatisticsReqDTO reqDTO);

  /**
   * 纠纷专题统计-各区域纠纷类型统计
   * @param reqDTO
   * @return
   */
  DubboResult<DisputeStatisticsResDTO> disputeTypeAreaStatisticsList2(DisputeStatisticsReqDTO reqDTO,
      List<String> disputeTypeCodes);

  /**
   * 纠纷专题统计-调解案件走势分析-街道调解案件数量分析-调解状态分析-申请人角色分析-调解结果分析
   * @param reqDTO
   * @return
   */
  DubboResult<DisputesSubjectStatisticsResDTO> disputesSubjectStatistics(DisputeStatisticsReqDTO reqDTO);


  /**
   * 调解员案件统计
   * 调解员指标权重统计使用(2018-11-26)
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<MediateStatisticsResDTO>> caseStatisticsByMediator(MediateStatisticsReqDTO reqDTO);

  /**
   * 调解机构案件统计
   * 调解机构指标权重统计使用(2018-11-26)
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<MediateStatisticsResDTO>> caseStatisticsByOrgId(MediateStatisticsReqDTO reqDTO);
}
