package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.MediationTdhCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.CloseCaseBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.ElisorConfirmationReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.MediationDecisionReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.MediationResultReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.RetractionRegisterRequisitionReqDTO;
import javax.validation.Valid;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by Jache on 2019/01/17 19:55.
 */
@Valid
public interface ThirdPartyPullApi {
  /**
  * @Description: 保存传输过来的司法确认书
   * @Param: [String aes 加密后]
  * @return: DubboResult
  * @Author:
   * @Date: 2019-01-21
   */
  DubboResult saveJudgeConfirmation(ElisorConfirmationReqDTO elisorConfirmationReqDTO);

  /**
  * @Description: 保存传输过来的调解书
   * @Param:[String aes 加密后]
  * @return: DubboResult
  * @Author:
   * @Date: 2019-01-21
  */
  DubboResult saveMediationBook(MediationDecisionReqDTO mediationDecisionReqDTO);

  /**
  * @Description: 保存传输过来的撤诉裁定书
   * @Param: [String aes 加密后]
  * @return: DubboResult
  * @Author:
   * @Date: 2019-01-21
   */
  DubboResult saveWithdrawBook(RetractionRegisterRequisitionReqDTO retractionRegisterRequisitionReqDTO);

  /**
   * @Description: 保存传输过来的诉中结案文书
   * @Param: [String aes 加密后]
   * @return: DubboResult
   * @Author:
   * @Date: 2019-01-21
   */
  DubboResult saveCloseCaseBook(CloseCaseBookReqDTO closeCaseBookReqDTO);

  /**
  * @Description: 插入引調案件
  * @Param: [reqDTO]
  * @return: com.beiming.framework.domain.DubboResult<java.lang.Long>
  * @Author: XZY
  * @Date: 2019/3/14/014
  */
  @Transactional
  DubboResult<Long> insertThirdPartyMediationCase(MediationTdhCaseReqDTO reqDTO);

  @Transactional
  DubboResult<Integer> updateApprovalCase(MediationTdhCaseReqDTO reqDTO);

  DubboResult dealMediationResult(MediationResultReqDTO mediationResultReqDTO);
}
