package com.beiming.odr.referee.dto;

import com.beiming.odr.referee.dto.requestdto.MediationCaseUserReqDTO;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.UserSexEnum;
import com.beiming.odr.referee.enums.UserTypeEnum;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

/**
 * @Auther: XZY
 * @Date: 2019/1/22/022 14:07
 * @Description: 通达海调解当事人推送实体
 */
@Data
@NoArgsConstructor
@JsonInclude(value = Include.NON_NULL)
public class CaseUserTdhDTO implements Serializable {

  private static final long serialVersionUID = 6230503728842285486L;

  private String dsrxh; //当事人ID
  private String dsrmc;  //当事人姓名
  private String sjhm;  //手机号
  private String dsrlx;  //当事人类型（ 自然人， 法人， 非法人组织）
  private String ssdw;  //"诉讼地位（ 原告被告）"
  private String xb;  //性别
  private String csrq;  //出生年月
  private String nl;  //年龄
  private String mz;  //民族
  private String zy;  //职业
  private String zjlx;  //证件类型
  private String zjhm;  //证件号
  private String dz;   //地址
  private String fddbr; //法定代表人
  private String gzdw; //工作单位
  private String hj; //户籍
  private String sfsmrz; //是否实名认证
  private List<CaseAgentTdhDTO> dlrlist; //代理人
  private String dsrzt;  //增删改
  private String gj = "15_GB0006-44"; //国籍 写死中国
  private String gbhdq = "15_GB0006-44"; //注册登记地国别
  private String zzjgdm;  //组织机构
  private String dwdz; //单位地址
  private String dbrzjhm; //代表人证件号码
  public CaseUserTdhDTO(MediationCaseUserReqDTO reqDTO) {
    this.dsrmc = reqDTO.getName();
    this.xb = UserSexEnum.valueOf(reqDTO.getSex()).getTdhCode();
    this.sjhm = reqDTO.getPhone();
    this.dsrlx = UserTypeEnum.valueOf(reqDTO.getUserType()).getTdhCode();
    this.ssdw = CaseUserTypeEnum.valueOf(reqDTO.getCaseUserType()).getTdhCode();
    this.dz = reqDTO.getAddress();
    this.zjhm = reqDTO.getIdCard();
    this.zjlx = reqDTO.getCardType();
    this.fddbr = reqDTO.getCorporation();
    this.zzjgdm = reqDTO.getCreditCode();
    this.dwdz = reqDTO.getAddress();
    this.dbrzjhm = reqDTO.getIdCard();
    if (StringUtils.isNotBlank(this.zjhm) && "09_00015-1".equals(this.zjlx)) {
      String birthday = StringUtils.substring(reqDTO.getIdCard(), 6, 14);
      String birthYear = StringUtils.substring(reqDTO.getIdCard(), 6, 10);
      int age = LocalDate.now().getYear() - Integer.parseInt(birthYear);
      this.setCsrq(birthday);
      this.setNl(String.valueOf(age));
    }
    if (reqDTO.getAgentName() != null) {
      CaseAgentTdhDTO caseAgentTdhDTO = new CaseAgentTdhDTO();
      caseAgentTdhDTO.setDlrxm(reqDTO.getAgentName());
      caseAgentTdhDTO.setSjhm(reqDTO.getAgentPhone());
      caseAgentTdhDTO.setZjhm(reqDTO.getAgentIdCard());
      caseAgentTdhDTO.setMode("1");
      this.dlrlist = Arrays.asList(caseAgentTdhDTO);
    }
    this.dsrzt = "1";
  }

}
