package com.beiming.odr.referee.dto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description:
 * @Date: Created 2018-08-21 18:18
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
public class FileDTO implements Serializable {

  private static final long serialVersionUID = -2627017796488364592L;

  public FileDTO(String fileId, String fileName) {
    this.fileId = fileId;
    this.fileName = fileName;
  }

  public FileDTO(String fileId, String fileName, String previewUrl) {
    this.fileId = fileId;
    this.fileName = fileName;
    this.previewUrl = previewUrl;
  }

  public FileDTO(String fileId, String fileName, String previewUrl, String tdhFileId) {
    this.fileId = fileId;
    this.fileName = fileName;
    this.previewUrl = previewUrl;
    this.tdhFileId = tdhFileId;
  }

  @NotNull(message = "{referee.paramFileIdNotBlank}")
  private String fileId;

  @NotNull(message = "{referee.fileNameNotBlank}")
  private String fileName;

  private String fileType;

  private String previewUrl;
  private String tdhFileId;

}
