package com.beiming.odr.referee.dto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 案件相关人
 * @Author: caiwei
 * @Date: Created 2018-06-25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationCasePersonnelDTO implements Serializable {

  private static final long serialVersionUID = 5946545033240232723L;

  /**
   * id
   */
  private Long id;

  /**
   * 案件号
   */
  private String caseNum;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 案件文书id
   */
  private Long documentId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型（0：申请人 1：被申请人）
   */
  private String caseUserType;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;

  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String name;

  /**
   * 性别
   */
  private String sex;

  /**
   * 联系电话
   */
  private String phone;

  /**
   * 身份证号
   */
  private String idCard;
  /**
   * 证件类型
   */
  private String cardType;

  private String cardTypeName;


  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 国家名称
   */
  private String nationName;

  /**
   * 国家code
   */
  private String nationCode;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 法人代表
   */
  private String corporation;

  /**
   * 代理人id
   */
  private Long agentId;

  /**
   * 代理人类型
   */
  private String agentType;

  /**
   * 代理人姓名
   */
  private String agentName;

  /**
   * 代理人性别
   */
  private String agentSex;

  /**
   * 代理人联系电话
   */
  private String agentPhone;

  /**
   * 代理人身份证号
   */
  private String agentIdCard;


  private String agentCardTypeName;
  /**
   * 排序
   */
  private Integer userOrder;

  /**
   * 固话
   */
  private String telephone;

  /**
   * 信访代理人委托书主键id
   */
  private String proxyId;

  /**
   * 信访代理人委托书id
   */
  private String proxyFileId;

  /**
   * 信访代理人委托书名称
   */
  private String proxyFileName;

  /**
   * 电子邮箱
   */
  private String email;

  /**
   * 審批狀態
   */
  private Integer approvalStatus;
 /**
   * 代理人審批狀態
   */
  private Integer approvalAgentStatus;
  private String agentEmail;
  private Boolean isRealName;
  private Boolean isAgentRealName;

  //代理人证件类型
  private String agentCardType;
  //国籍
  private String nationality;
  //代理人国籍
  private String agentNationality;
  //民族
  private String nation;
  //代理人民族
  private String agentNation;

  private Boolean videoAuthenticationFlag;

  private Boolean agentVideoAuthenticationFlag;

  private String agentProvCode;

  private String agentCityCode;

  private String agentAreaCode;

  private String agentStreetCode;

  private String agentProvName;

  private String agentCityName;

  private String agentAreaName;

  private String agentStreetName;

  private String agentAddress;

  /**
   * 国家名称
   */
  private String agentNationName;

  /**
   * 国家code
   */
  private String agentNationCode;

  public MediationCasePersonnelDTO(Long userId, String caseUserType, String name, String sex,
      String phone, String idCard, String address, String creditCode, String agentName,
      String agentSex, String agentPhone, String agentIdCard, Integer order) {
    super();
    this.userId = userId;
    this.caseUserType = caseUserType;
    this.name = name;
    this.sex = sex;
    this.phone = phone;
    this.idCard = idCard;
    this.address = address;
    this.creditCode = creditCode;
    this.agentName = agentName;
    this.agentSex = agentSex;
    this.agentPhone = agentPhone;
    this.agentIdCard = agentIdCard;
    this.userOrder = order;

  }

}
