package com.beiming.odr.referee.dto;

import com.beiming.odr.referee.dto.responsedto.LawAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationActualResDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.util.List;

/**
 * 调解记录信息，对接的对象。
 *
 */
@Data
@ApiModel(description = "调解记录信息")
public class ThirdPartMediationInfoTO implements Serializable {
  @ApiModelProperty(notes = "案件ID", example = "484")
  private Long caseId;
  @ApiModelProperty(notes = "案件号", example = "166C2CF751B55")
  private String caseNo;
  @ApiModelProperty(notes = "登记时间", example = "1541129477000")
  private Long createTime;
  @ApiModelProperty(notes = "案件状态", example = "START_ORDER_MEDIATION_TIME")
  private String lawCaseStatus;
  @ApiModelProperty(notes = "案件状态Code", example = "ADJACENCY_RELATION")
  private String lawCaseStatusCode;

  @ApiModelProperty(notes = "案件来源", example = "MASTIFF_API")
  private String origin;
  @ApiModelProperty(notes = "调解机构Id", example = "10045")
  private Long orgId;
  @ApiModelProperty(notes = "调解机构", example = "老山街道东里南社区调解委员会")
  private String orgName;
  @ApiModelProperty(notes = "调解机构区域Code", example = "110107002015")
  private String orgAreaCode;
  @ApiModelProperty(notes = "机构受理状态", example = "START")
  private String orgConfirm;
  @ApiModelProperty(notes = "申请人诉求", example = "水电费")
  private String appeal;

  @ApiModelProperty(notes = "调解类型", example = "PEOPLE_MEDIATION")
  private String mediationType;
  @ApiModelProperty(notes = "纠纷类型", example = "ADJACENCY_RELATION")
  private String disputeType;
  @ApiModelProperty(notes = "纠纷类型Code", example = "4110100000000")
  private String disputeTypeCode;
  @ApiModelProperty(notes = "纠纷描述", example = "打的")
  private String disputeContent;
  @ApiModelProperty(notes = "发生地代号：省", example = "1100000000")
  private String provCode;
  @ApiModelProperty(notes = "发生地代号：市", example = "110100000000")
  private String cityCode;
  @ApiModelProperty(notes = "发生地代号：区", example = "110107000000")
  private String areaCode;
  @ApiModelProperty(notes = "发生地代号：街道", example = "110107002000")
  private String streetCode;
  @ApiModelProperty(notes = "发生地代号：社区", example = "110107002000")
  private String communityCode;

  @ApiModelProperty(notes = "发生地名称：省", example = "北京市")
  private String provName;
  @ApiModelProperty(notes = "发生地名称：市", example = "市辖区")
  private String cityName;
  @ApiModelProperty(notes = "发生地名称：区", example = "石景山区")
  private String areaName;
  @ApiModelProperty(notes = "发生地名称：街道", example = "老山街道")
  private String streetName;
  @ApiModelProperty(notes = "发生地名称：社区", example = "金山社区")
  private String communityName;
  @ApiModelProperty(notes = "详细地址", example = "厦门市")
  private String address;

  /**
   * 国家名称
   */
  private String nationName;

  /**
   * 国家code
   */
  private String nationCode;


  @ApiModelProperty(notes = "申请人和代理人", example = "申请人和代理人")
  private List<MediationCasePersonnelDTO> applicants;
  @ApiModelProperty(notes = "被申请人和代理人", example = "被申请人和代理人")
  private List<MediationCasePersonnelDTO> respondents;
  @ApiModelProperty(notes = "调解员", example = "调解员")
  private List<MediationActualResDTO> mediators;
  @ApiModelProperty(notes = "证据材料列表", example = "证据材料列表,只传fileid")
  private List<LawAttachmentResDTO> fileList;

}
