package com.beiming.odr.referee.dto.requestdto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 多文件上传
 * 
 * @author chenjt
 *
 * @2018年8月22日
 */
@Data
@ApiModel(description = "多文件上传请求参数")
public class BatchFilesDTO implements Serializable {


  private static final long serialVersionUID = 8041985578406016617L;

  @ApiModelProperty(notes = "案件ID", required = true, example = "166")
  @NotNull(message = "{mastiff.caseIdNotBlank}")//案件id不能为空
  private Long caseId;

  @ApiModelProperty(notes = "数据来源接口 /mastiff/file/materialType 返回的参数 materialTypes集合中的某一类code值", required = true, example = "IDENTITY_CERTIFICATE")
  @NotNull(message = "{mastiff.categoryMiddleNotBlank}")//categoryMiddle不能为空
  private String categoryMiddle;

  @ApiModelProperty(notes = "数据来源接口 /mastiff/file/materialType 返回的参数 materialSubTypes集合中的某一子类的code值", required = true, example = "AUTHORIZE_PROXY")
  @NotNull(message = "{mastiff.signNotBlank}")//sign不能为空
  private String sign;

  @ApiModelProperty(hidden = true)
  private String userName;

  @Valid
  @ApiModelProperty(notes = "文件", required = true)
  @NotNull(message = "{mastiff.filesNotBlank}")//文件不能为空
  @Size(message = "{mastiff.filesNotBlank}", min = 1)//文件不能为空
  private List<FilesUploadDTO> files;

  private String fileType;
}
