package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.dto.FileDTO;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 生成电子卷宗之前上传多个文件
 * 
 * @author chenjt
 * @data 2018年8月22日
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BatchFilesReqDTO implements Serializable {

  private static final long serialVersionUID = 4772247537899586575L;
  @NotNull(message = "{referee.paramCaseIdNotBlank}")
  private Long caseId;

  @NotNull(message = "{referee.fileNotBlank}")
  @Size(message = "{referee.fileNotBlank}", min = 1)
  private List<FileDTO> files;
  
  @NotNull(message = "{referee.signNotBlank}")
  private String sign;
//  @NotNull(message = "{referee.userIdNotBlank}")
  private Long userId;
  private String categoryMiddle;
  private String userName;
  private String objectType; // 类型
  private String categoryBig;
  private String previewUrl;
  private Long meetingId; // 会议id
  private String fileType; // 材料类型
}
