package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.MediationSuccessEnum;
import java.io.Serializable;
import lombok.Data;

/**
 * @Description: 撤回案件请求参数
 * @Author: caiwei
 * @Date: Created 2018-07-13
 */
@Data
public class CancelCaseReqDTO implements Serializable {

  private static final long serialVersionUID = -630601399298676701L;
  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 案件状态
   */
  private String caseStatus;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;


  /**
   * 原因枚举
   */
  private MediationSuccessEnum reasonType;

  /**
   * 撤回原因
   */
  private String reason;



}
