package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import com.beiming.odr.referee.enums.MeetingOrderEnum;

/**
 * 添加会议dto
 * 
 * @author qsh
 * @data 2018年6月22日
 */
@Data
public class CaseMeetingSaveReqDTO implements Serializable {
  private static final long serialVersionUID = 1L;
  private Long lawCaseId; // 案件id
  private String caseMeetingName; // 会议名称
  private String meetingType; // 会议类型  
  private MeetingOrderEnum orderType; // 预约类型 
  private int meetingHour; // 会议时长
  private int meetingMin; // 会议时长
  private String meetingContent; // 会议内容
  private String orderAddress; // 会议地址
  private String joinUserId; // 参加会议人员id以逗号隔开
  private Date startTime; // 会议开始时间
  private Date endTime; // 会议结束时间
  private Date orderTime; // 会议预订时间
  private String inviteCode; // 观摩人的邀请码
  private String sendRecordStatus; // 是否发送
  private String createUser; // 创建人
  private Long userId;
  private String userName;

}
