package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.responsedto.CaseProtocolPersonnelResDTO;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.UserSexEnum;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @Description: 案件协议人员请求参数
 * @Author: caiwei
 * @Date: Created 2018-07-01
 */
@Data
@AllArgsConstructor
public class CaseProtocolPersonnelReqDTO implements Serializable {

  private static final long serialVersionUID = 7988498493297314452L;

  // 人员id
  private Long personnelId;

  // 案件id
  private Long caseId;

  // 文书id
  private Long documentId;

  // 案件人员类型
  private CaseUserTypeEnum caseUserType;

  // 用户类型
  private String userType;

  // 用户id
  private Long userId;

  // 用户姓名
  private String userName;

  // 手机号
  private String phone;

  // 性别
  private UserSexEnum sex;

  // 身份证号
  private String idCard;

  // 省份code
  private String provCode;

  // 城市code
  private String cityCode;

  // 区code
  private String areaCode;

  // 街道code
  private String streetCode;

  // 省份名称
  private String provName;

  // 城市名称
  private String cityName;

  // 区名称
  private String areaName;

  // 街道名称
  private String streetName;

  // 详细地址
  private String address;

  // 信用代码
  private String creditCode;

  // 法人代表
  private String corporation;

  // 排序
  private Integer order;

  /**
   * 代理人id
   */
  private Long agentId;

  /**
   * 代理人类型
   */
  private String agentType;

  /**
   * 代理人姓名
   */
  private String agentName;

  /**
   * 代理人性别
   */
  private String agentSex;

  /**
   * 代理人身份证
   */
  private String agentIdCard;

  /**
   * 代理人手机号
   */
  private String agentPhone;

  /**
   * 电子邮箱
   */
  private String email;
  private String agentEmail;
  private String cardType;
  private String agentCardType;
  private String nationality;
  private String agentNationality;
  private String nation;
  private String agentNation;

  private String nationCode;

  private String nationName;

  public CaseProtocolPersonnelReqDTO() {
    // xx
  }

  /**
   * 不对ID类设值PersonnelId、CaseId、DocumentId
   *
   * @param casePer
   */
  public CaseProtocolPersonnelReqDTO(MediationCasePersonnelDTO casePer) {
    // this.setPersonnelId(null);
    // this.setCaseId(null);
    // this.setDocumentId(null);
    this.setUserId(casePer.getUserId());
    this.setUserType(casePer.getUserType());
    this.setPhone(casePer.getPhone());
    this.setCaseUserType(CaseUserTypeEnum.valueOf(casePer.getCaseUserType()));
    this.setUserName(casePer.getName());
    if (!StringUtils.isBlank(casePer.getSex())) {
      this.setSex(UserSexEnum.valueOf(casePer.getSex()));
    }
    this.setIdCard(casePer.getIdCard());
    this.setProvCode(casePer.getProvCode());
    this.setCityCode(casePer.getCityCode());
    this.setAreaCode(casePer.getAreaCode());
    this.setStreetCode(casePer.getStreetCode());
    this.setProvName(casePer.getProvName());
    this.setCityName(casePer.getCityName());
    this.setAreaName(casePer.getAreaName());
    this.setStreetName(casePer.getStreetName());
    this.setAddress(casePer.getAddress());
    this.setOrder(casePer.getUserOrder());
    this.setAgentId(casePer.getAgentId());
    this.setAgentIdCard(casePer.getAgentIdCard());
    this.setAgentName(casePer.getAgentName());
    this.setAgentPhone(casePer.getAgentPhone());
    this.setAgentSex(casePer.getAgentSex());
    this.setAgentType(casePer.getAgentType());
    this.setAgentEmail(casePer.getAgentEmail());
    this.setEmail(casePer.getEmail());
  }

  /**
   * 不对ID类设值PersonnelId、CaseId、DocumentId
   *
   * @param casePer
   */
  public CaseProtocolPersonnelReqDTO(CaseProtocolPersonnelResDTO casePer) {
    // this.setPersonnelId(null);
    // this.setCaseId(null);
    // this.setDocumentId(null);
    this.setUserId(casePer.getUserId());
    this.setUserType(casePer.getUserType());
    this.setPhone(casePer.getPhone());
    this.setCaseUserType(CaseUserTypeEnum.valueOf(casePer.getCaseUserType()));
    this.setUserName(casePer.getUserName());
    if (!StringUtils.isBlank(casePer.getSex())) {
      this.setSex(UserSexEnum.valueOf(casePer.getSex()));
    }
    this.setIdCard(casePer.getIdCard());
    this.setProvCode(casePer.getProvCode());
    this.setCityCode(casePer.getCityCode());
    this.setAreaCode(casePer.getAreaCode());
    this.setStreetCode(casePer.getStreetCode());
    this.setProvName(casePer.getProvName());
    this.setCityName(casePer.getCityName());
    this.setAreaName(casePer.getAreaName());
    this.setStreetName(casePer.getStreetName());
    this.setAddress(casePer.getAddress());
    this.setOrder(casePer.getUserOrder());
    this.setAgentId(casePer.getAgentId());
    this.setAgentIdCard(casePer.getAgentIdCard());
    this.setAgentName(casePer.getAgentName());
    this.setAgentPhone(casePer.getAgentPhone());
    this.setAgentSex(casePer.getAgentSex());
    this.setAgentType(casePer.getAgentType());
    this.setAgentEmail(casePer.getAgentEmail());
    this.setEmail(casePer.getEmail());
  }

  /**
   * 不对ID类设值PersonnelId、CaseId、DocumentId<br>
   * 不对Order排序设值
   *
   * @param casePer
   */
  public CaseProtocolPersonnelReqDTO(MediationDissentSaveReqDTO reqDTO) {
    // this.setPersonnelId(null);
    // this.setCaseId(null);
    // this.setDocumentId(null);
    // this.setOrder(null);
    this.setUserId(reqDTO.getUserId());
    this.setPhone(reqDTO.getPhone());
    this.setUserType(reqDTO.getUserType());
    this.setCaseUserType(CaseUserTypeEnum.valueOf(reqDTO.getCaseUserType()));
    this.setUserName(reqDTO.getUserName());
    if (!StringUtils.isBlank(reqDTO.getSex())) {
      this.setSex(UserSexEnum.valueOf(reqDTO.getSex()));
    }
    this.setIdCard(reqDTO.getIdCard());
    this.setProvCode(reqDTO.getProvCode());
    this.setCityCode(reqDTO.getCityCode());
    this.setAreaCode(reqDTO.getAreaCode());
    this.setStreetCode(reqDTO.getStreetCode());
    this.setProvName(reqDTO.getProvName());
    this.setCityName(reqDTO.getCityName());
    this.setAreaName(reqDTO.getAreaName());
    this.setStreetName(reqDTO.getStreetName());
    this.setAddress(reqDTO.getAddress());

    this.setEmail(reqDTO.getEmail());

    // this.setAgentId(reqDTO.getAgentId());
    // this.setAgentIdCard(reqDTO.getAgentIdCard());
    // this.setAgentName(reqDTO.getAgentName());
    // this.setAgentPhone(reqDTO.getAgentPhone());
    // this.setAgentSex(reqDTO.getAgentSex());
    // this.setAgentType(reqDTO.getAgentType());
  }

}
