package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @Description: 删除案件人实体类
 * @Author: caiwei
 * @Date: Created 2018-08-01
 */
@Data
public class DeleteCasePersonnelReqDTO implements Serializable {

  private static final long serialVersionUID = -7952267309437445596L;
  // 案件id
  @NotNull(message = "{referee.paramCaseIdNotBlank}")
  private Long caseId;

  // 人员id
  @NotNull(message = "{referee.personIdNotBlank}")
  private Long personnelId;

  // 用户id
  @NotNull(message = "{referee.userIdNotBlank}")
  private Long userId;

  @ApiModelProperty(value = "用户类型")
  private CaseUserTypeEnum caseUserType;
}
