package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 纠纷统计
 * @Date: Created 2018-07-05 10:02
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputeStatisticsReqDTO implements Serializable {

  private static final long serialVersionUID = -5600251953659639523L;

  /**
   * 纠纷发生区域
   */
  private String areaCode;

  /**
   * 纠纷发生区域层级 level
   */
  private Integer areaCodeLevel;

  /**
   * 纠纷发生区域本级及下级(调用端不必传此参数)
   */
  private List<String> areaCodeList;

  /**
   * 纠纷发生区域截取长度(调用端不必传此参数)
   */
  private Integer cutLength;

  /**
   * 开始时间
   */
  private String startDate;

  /**
   * 结束时间
   */
  private String endDate;

  /**
   * 纠纷类型code(新报表使用2018-11-11)
   */
  private String disputeTypeCode;

  private Boolean multilevel;
}
