package com.beiming.odr.referee.dto.requestdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description: 上传文件信息
 * @Author: chenjt
 * @Date: Created 2018-08-22
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "上传的文件信息", description = "上传的文件信息")
public class FilesUploadDTO implements Serializable {

  private static final long serialVersionUID = -5958179749933938688L;

  @ApiModelProperty(notes = "文件id", required = true, example = "53348bbf7f3f450aad61d3dc20544f10")
  @NotNull(message = "{mastiff.fileIdNotBlank}")//文件id不能为空
  private String fileId;

  @ApiModelProperty(notes = "文件名", required = true, example = "合同")
  @NotNull(message = "{mastiff.fileNameNotBlank}")//文件名不能为空
  private String fileName;

  //给国商对接时用到
  @ApiModelProperty(notes = "Base64FileString", example = "xxxxx")
  private String fileBase64;

  @ApiModelProperty(notes = "预览url", example = "dadasdasd")
  private String previewUrl;

  @ApiModelProperty(notes = "通达海材料id", example = "dadasdasd", required = false)
  private String tdhFileId;
}
