package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.UserSexEnum;
import java.io.Serializable;
import lombok.Data;

/**
 * @Description: 保存司法确认申请书人员信息请求参数
 * @Author: caiwei
 * @Date: Created 2018-08-10
 */
@Data
public class JudicialConfirmPersonnelReqDTO implements Serializable {

  private static final long serialVersionUID = 2670371667234074684L;

  /**
   * 人员id
   */
  private Long personnelId;

  /**
   * 案件人员类型
   */
  private CaseUserTypeEnum caseUserType;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 用户姓名
   */
  private String name;

  /**
   * 用户类型
   */
  private String userType;

  /**
   * 手机号
   */
  private String phone;

  /**
   * 性别
   */
  private UserSexEnum sex;

  /**
   * 身份证号
   */
  private String idCard;

  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 法人代表
   */
  private String corporation;

  /**
   * 代理人id
   */
  private Long agentId;

  /**
   * 代理人类型
   */
  private String agentType;

  /**
   * 代理人姓名
   */
  private String agentName;

  /**
   * 代理人性别
   */
  private String agentSex;

  /**
   * 代理人身份证
   */
  private String agentIdCard;

  /**
   * 代理人手机号
   */
  private String agentPhone;

  /**
   * 排序
   */
  private Integer order;
}
