package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.RegisterOriginEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description: 录入调解案件用户信息
 * @Author: caiwei
 * @Date: Created 2018-06-27
 */
@Data
public class MediationCaseUserReqDTO implements Serializable {

  private static final long serialVersionUID = 525392647113077587L;

  // id
  private Long id;

  // 案件id
  private Long caseId;

  // 用户id
  private Long userId;

  // 案件用户类型
  private String caseUserType;

  // 用户类型
  private String userType;

  /**
   * 国家名称
   */
  @ApiModelProperty(notes = "国家名称")
  private String nationName;

  /**
   * 国家code
   */
  @ApiModelProperty(notes = "国家code")
  private String nationCode;

  // 名称
  private String name;

  // 性别
  private String sex;

  // 联系电话
  private String phone;

  // 固定电话
  private String telephone;

  // 身份证号
  private String idCard;

  // 省份code
  private String provCode;

  // 城市code
  private String cityCode;

  // 区code
  private String areaCode;

  // 街道code
  private String streetCode;

  // 省份名称
  private String provName;

  // 城市名称
  private String cityName;

  // 区名称
  private String areaName;

  // 街道名称
  private String streetName;

  // 详细地址
  private String address;

  // 信用代码
  private String creditCode;

  // 法人代表
  private String corporation;

  // 代理人id
  private Long agentId;

  // 代理人类型
  private String agentType;

  // 代理人姓名
  private String agentName;

  // 代理人性别
  private String agentSex;

  // 代理人联系电话
  private String agentPhone;

  // 代理人身份证号
  private String agentIdCard;

  // 代理人委托书id
  private String agentFileId;

  // 代理人委托书名称
  private String agentFileName;

  //代理人委托书文件Base64String
  private String agentBase64File;

  // 代理人证明文件
  private PartyAgentFilesRequestDTO partyAgentFilesRequestDTO;

  // 排序
  private Integer order;

  // 代理人注册来源(REGISTER_SELF: 用户自己注册 REGISTER_PLATFORM: 平台自动注册)
  private RegisterOriginEnum agentRegisterOrigin;

  // 用户注册来源(REGISTER_SELF: 用户自己注册 REGISTER_PLATFORM: 平台自动注册)
  private RegisterOriginEnum userRegisterOrigin;

  // 创建者
  private String createUser;

  // 更新者
  private String updateUser;

  // 电子邮箱
  private String email;

  //引调用户id
  private String citePartyId;
 // 引调代理人id
  private String citeAgentId;

  private String agentEmail;
  //证件类型
  private String cardType;
  //代理人证件类型
  private String agentCardType;
  //国籍
  private String nationality;
  //代理人国籍
  private String agentNationality;
  //民族
  private String nation;
  //代理人民族
  private String agentNation;


  private String agentProvCode;

  private String agentCityCode;

  private String agentAreaCode;

  private String agentStreetCode;

  private String agentProvName;

  private String agentCityName;

  private String agentAreaName;

  private String agentStreetName;

  private String agentAddress;

  /**
   * 国家名称
   */
  private String agentNationName;

  /**
   * 国家code
   */
  private String agentNationCode;
}
