package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import com.beiming.framework.page.PageQuery;
import com.beiming.odr.referee.dto.MediationListDTO;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 查询调解列表的请求参数
 * 
 * @author DJQ 2018年7月9日
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MediationListReqDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  private String roleType; // 用户角色类型： 纠纷登记员 调解人 普通人
  private Long userId; // 用户ID
  private String userType; // 用户类型（申请人，被申请人，调解人）
  private Long orgId; // 服务机构编号
  private String disputeTypeCode; // 纠纷类型
  private String disputeNo; // 纠纷编号
  private List<CaseProgressEnum> caseProgress; // 案件进度
  // private String areaCode; // 地区编号
  private String provCode; // 省份code
  private String cityCode; // 城市code
  private String areaCode; // 区code
  private String streetCode; // 街道code
  private String keyWord; // 关键词 编号、姓名、案号
  private String startTime;
  private String endTime;

  private String mediationType; // 调解类型
  private String partyName; //当事人姓名

  /**
   * 转换为Mapper查询对象
   * 
   * @return
   */
  public MediationListDTO convertMediationListDTO(List<String> caseStatus) {
    MediationListDTO listDTO = new MediationListDTO();

    listDTO.setRoleType(roleType); // 用户角色类型： 纠纷登记员 调解人 普通人
    listDTO.setUserId(userId); // 用户ID
    listDTO.setUserType(userType); // 用户类型（申请人，被申请人，调解人）
    listDTO.setOrgId(orgId); // 服务机构编号

    listDTO.setDisputeTypeCode(disputeTypeCode); // 纠纷类型
    listDTO.setDisputeNo(disputeNo); // 纠纷编号
    listDTO.setCaseStatus(caseStatus); // 案件进度
    // listDTO.setareaCode; // 地区编号
    listDTO.setProvCode(provCode); // 省份code
    listDTO.setCityCode(cityCode); // 城市code
    listDTO.setAreaCode(areaCode); // 区code
    listDTO.setStreetCode(streetCode); // 街道code
    listDTO.setKeyWord(keyWord); // 关键词 编号、姓名、案号
    listDTO.setStartTime(startTime);
    listDTO.setEndTime(endTime);
    listDTO.setMediationType(mediationType);
    listDTO.setPartyName(partyName);
    listDTO.setPageIndex(this.getPageIndex());
    listDTO.setPageSize(this.getPageSize());
    return listDTO;
  }

}
