package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Data;
import com.beiming.odr.referee.enums.MeetingTypeNewEnum;

/**
 * 新版添加会议dto
 * 
 * @author qsh
 * @data 2018年6月22日
 */
@Data
public class MeetingNewSaveReqDTO extends CommonIdReqDTO implements Serializable {
  private static final long serialVersionUID = 1L;

  /**
   * @see MeetingTypeNewEnum
   */
  @NotNull(message = "{referee.meetingTypeNotBlank}")
  private MeetingTypeNewEnum meetingTypeNewEnum;
  private String joinUserId;
  @NotNull(message = "{referee.orderTimeNotBlank}")
  private Date orderTime;
  private String orderAddress;
  private Long userId;
  private String userName;

  public static CaseMeetingSaveReqDTO converCaseMeetingSaveReqDTO(
      MeetingNewSaveReqDTO meetingNewSaveReqDTO) {
    CaseMeetingSaveReqDTO caseMeetingSaveReqDTO = new CaseMeetingSaveReqDTO();
    caseMeetingSaveReqDTO.setCreateUser(meetingNewSaveReqDTO.getUserName());
    caseMeetingSaveReqDTO.setJoinUserId(meetingNewSaveReqDTO.getJoinUserId());
    caseMeetingSaveReqDTO.setLawCaseId(meetingNewSaveReqDTO.getId());
    caseMeetingSaveReqDTO.setMeetingType(meetingNewSaveReqDTO.getMeetingTypeNewEnum().toString());
    caseMeetingSaveReqDTO.setOrderAddress(meetingNewSaveReqDTO.getOrderAddress());
    caseMeetingSaveReqDTO.setStartTime(meetingNewSaveReqDTO.getOrderTime());
    caseMeetingSaveReqDTO.setOrderTime(meetingNewSaveReqDTO.getOrderTime());
    caseMeetingSaveReqDTO.setUserId(meetingNewSaveReqDTO.getUserId());
    caseMeetingSaveReqDTO.setUserName(meetingNewSaveReqDTO.getUserName());
    caseMeetingSaveReqDTO.setCreateUser(meetingNewSaveReqDTO.getUserName());
    return caseMeetingSaveReqDTO;
  }
}
