package com.beiming.odr.referee.dto.requestdto;

import com.alibaba.fastjson.JSONObject;
import com.beiming.odr.referee.enums.DocumentTypeEnum;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @Description: 保存调解申请书请求参数
 * @Author: caiwei
 * @Date: Created 2018-08-10
 */
@Data
public class SaveMediationApplyBookReqDTO implements Serializable {


  private static final long serialVersionUID = -3725392030007012146L;
  /**
   * 调解申请书id
   */
  private Long docId;

  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 申请方
   */
  private List<JudicialConfirmPersonnelReqDTO> personnelList;

  /**
   * 请求事项
   */
  private String requestContent;

  /**
   * 事实和理由
   */
  private String factAndReason;

  /**
   * 地区code
   */
  private String areaCode;

  /**
   * 地区名称
   */
  private String areaName;

  /**
   * 受理法院code
   */
  private String courtCode;

  /**
   * 受理法院名称
   */
  private String courtName;

  /**
   * 案由code
   */
  private String causeCode;

  /**
   * 案由名称
   */
  private String causeName;

  /**
   * 案件类型code(华宇)
   */
  private String caseTypeCode;

  /**
   * 案件类型名称(华宇)
   */
  private String caseTypeName;

  /**
   * 创建者id
   */
  private Long createId;

  /**
   * 创建者
   */
  private String createUser;

  /**
   * 更新者
   */
  private String updateUser;

  public static SaveProtocolBookReqDTO getSaveProtocolBookReqDTO(SaveMediationApplyBookReqDTO dto) {
    SaveProtocolBookReqDTO reqDTO = new SaveProtocolBookReqDTO();
    reqDTO.setProtocolId(dto.getDocId());
    reqDTO.setCaseId(dto.getCaseId());
    reqDTO.setDocumentType(DocumentTypeEnum.MEDIATION_APPLY_BOOK);
    List<CaseProtocolPersonnelReqDTO> list = Lists.newArrayList();
    for (JudicialConfirmPersonnelReqDTO req : dto.getPersonnelList()) {
      CaseProtocolPersonnelReqDTO protocol = new CaseProtocolPersonnelReqDTO();
      protocol.setPersonnelId(req.getPersonnelId());
      protocol.setCaseId(dto.getCaseId());
      protocol.setDocumentId(dto.getDocId());
      protocol.setCaseUserType(req.getCaseUserType());
      protocol.setUserType(req.getUserType());
      protocol.setUserId(req.getUserId());
      protocol.setUserName(req.getName());
      protocol.setPhone(req.getPhone());
      protocol.setSex(req.getSex());
      protocol.setIdCard(req.getIdCard());
      protocol.setProvCode(req.getProvCode());
      protocol.setCityCode(req.getCityCode());
      protocol.setAreaCode(req.getAreaCode());
      protocol.setStreetCode(req.getStreetCode());
      protocol.setProvName(req.getProvName());
      protocol.setCityName(req.getCityName());
      protocol.setAreaName(req.getAreaName());
      protocol.setStreetName(req.getStreetName());
      protocol.setAddress(req.getAddress());
      protocol.setCreditCode(req.getCreditCode());
      protocol.setCorporation(req.getCorporation());
      protocol.setAgentId(req.getAgentId());
      protocol.setAgentType(req.getAgentType());
      protocol.setAgentName(req.getAgentName());
      protocol.setAgentSex(req.getAgentSex());
      protocol.setAgentPhone(req.getAgentPhone());
      protocol.setAgentIdCard(req.getAgentIdCard());
      list.add(protocol);
    }
    reqDTO.setPersonnelList(list);
    reqDTO.setContent(dto.getRequestContent());
    JSONObject object = new JSONObject();
    object.put("factAndReason", dto.getFactAndReason());
    object.put("areaCode", dto.getAreaCode());
    object.put("areaName", dto.getAreaName());
    object.put("courtCode", dto.getCourtCode());
    object.put("courtName", dto.getCourtName());
    object.put("causeCode", dto.getCauseCode());
    object.put("causeName", dto.getCauseName());
    object.put("caseTypeCode", dto.getCaseTypeCode());
    object.put("caseTypeName", dto.getCaseTypeName());
    reqDTO.setExtendJson(object.toJSONString());
    reqDTO.setCreateUser(dto.getCreateUser());
    reqDTO.setUpdateUser(dto.getUpdateUser());
    return reqDTO;
  }
}
