package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 签名请求的基础信息参数
 * 
 * @author DJQ 2018-07-05
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SignatureInfoReqDTO implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  @NotNull(message = "{referee.paramUserIdNotBlank}")
  private Long userId; // 用户ID
  @NotNull(message = "{referee.paramDocumentIdNotBlank}")
  private Long documentId; // 文书ID
  @NotNull(message = "{referee.paramImgIdNotBlank}")
  private String imgId; // 图像文件ID
  @NotNull(message = "{referee.paramImgDegreeNotBlank}")
  private Integer degree; // 旋转度数90，180，270

}
