package com.beiming.odr.referee.dto.responsedto;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chen
 * @date 2024/09/30
 */
@Data
@ApiModel(description = "已预约视频返回参数")
@AllArgsConstructor
@NoArgsConstructor
public class BookedCaseMeetingListResponseDTO implements Serializable {

  private static final long serialVersionUID = 4512982893469922119L;
  @ApiModelProperty(notes = "案件id", example = "121")
  private Long lawCaseId;

  @ApiModelProperty(notes = "会议id", example = "1986")
  private Long meetingId;

  @ApiModelProperty(notes = "房间id", example = "1111")
  private String roomId;

  @ApiModelProperty(notes = "视频服务id", example = "aaaa")
  private String meetingVideoId;

  @ApiModelProperty(notes = "视频状态", example = "NOT_END")
  private String meetingStatus;

  @ApiModelProperty(notes = "案件编号", example = "（2024）多元化解17号")
  private String caseNo;

  @ApiModelProperty(notes = "纠纷类型代码", example = "DEFAULT_DISPUTE")
  private String disputeTypeCode;

  @ApiModelProperty(notes = "纠纷类型", example = "生命权、健康权、身体权纠纷")
  private String disputeType;

  @ApiModelProperty(notes = "机构id", example = "2251")
  private Long orgId;

  @ApiModelProperty(notes = "机构名称", example = "海南省一中院")
  private String orgName;

  @ApiModelProperty(notes = "会议类型", example = "视频会议")
  private String meetingType;

  @ApiModelProperty(notes = "预约类型", example = "MEETING_ONLINE_MEDIATE")
  private String orderType;

  @ApiModelProperty(notes = "预约时间", example = "预约日期非当日，则显示预约时间时要显示日期+时间 否则显示时间")
  private String orderTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty(notes = "开始时间", example = "2024-01-01 12:00:00")
  private Date startTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty(notes = "结束时间", example = "2024-01-01 12:00:00")
  private Date endTime;

}
