package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import lombok.Data;

/**
 * 调解记录实体类
 *
 * @author qsh
 * @data 2018年6月29日
 */
@Data
public class CaseMeetingListResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long id;
  private Long lawCaseId; // 案件id
  private Long meetingId; //即为id
  private String meetingType; // 会议类型
  private String meetingStatus; // 会议状态 NOT_END：未结束END结束,会议进行中：UNDERWAY
  private String meetingContent; // 会议内容
  private String orderType; // 预约类型 0:online 1:offline
  private String inviteCode; // 观摩人的邀请码
  private String joinUserId; // 参与者id
  private String meetingVideoId; // 视频服务id
  private String joinUserName; // 参与者
  private String meetingName; //会议名称
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date createTime;
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date orderTime; //预约会议
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date endTime; //会议结束时间

  private CaseMeetingDocumentResDTO caseMeetingDocumentResDTO;
  /**
   * 参与用户的情绪
   */
  private List<UserEmotionResDTO> joinUser;

}
