package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 协议相关人返回实体
 * @Author: caiwei
 * @Date: Created 2018-06-30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CaseProtocolPersonnelResDTO implements Serializable {

  private static final long serialVersionUID = -4866238168967161027L;
  // 人员id
  private Long personnelId;

  // 文书id
  private Long documentId;

  // 案件用户类型
  private String caseUserType;

  // 用户ID
  private Long userId;

  // 用户类型
  private String userType;

  // 名称
  private String userName;

  // 性别
  private String sex;

  // 电话
  private String phone;

  // 身份证号
  private String idCard;

  // 省份code
  private String provCode;

  // 城市code
  private String cityCode;

  // 区code
  private String areaCode;

  // 街道code
  private String streetCode;

  // 省份名称
  private String provName;

  // 城市名称
  private String cityName;

  // 区名称
  private String areaName;

  // 街道名称
  private String streetName;

  // 详细地址
  private String address;

  /**
   * 国家名称
   */
  private String nationName;

  /**
   * 国家code
   */
  private String nationCode;

  // 信用代码
  private String creditCode;

  // 法人代表
  private String corporation;

  /**
   * 代理人id
   */
  private Long agentId;

  /**
   * 代理人类型
   */
  private String agentType;
  
  /**
   * 代理人姓名
   */
  private String agentName;

  /**
   * 代理人性别
   */
  private String agentSex;

  /**
   * 代理人联系电话
   */
  private String agentPhone;

  /**
   * 代理人身份证号
   */
  private String agentIdCard;

  /**
   * 电子邮箱
   */
  private String email;

  // 排序
  private Integer userOrder;

  private String agentEmail;
  //证件类型
  private String cardType;
  //代理人证件类型
  private String agentCardType;
  //国籍
  private String nationality;
  //代理人国籍
  private String agentNationality;
  //民族
  private String nation;
  //代理人民族
  private String agentNation;

  private String agentProvCode;

  private String agentCityCode;

  private String agentAreaCode;

  private String agentStreetCode;

  private String agentProvName;

  private String agentCityName;

  private String agentAreaName;

  private String agentStreetName;

  private String agentAddress;

  /**
   * 国家名称
   */
  private String agentNationName;

  /**
   * 国家code
   */
  private String agentNationCode;



  public CaseProtocolPersonnelResDTO(MediationCasePersonnelDTO personnel) {
    this.documentId = personnel.getDocumentId();
    this.caseUserType = personnel.getCaseUserType();
    this.userId = personnel.getUserId();
    this.userType = personnel.getUserType();
    this.userName = personnel.getName();
    this.sex = personnel.getSex();
    this.phone = personnel.getPhone();
    this.idCard = personnel.getIdCard();
    this.provCode = personnel.getProvCode();
    this.cityCode = personnel.getCityCode();
    this.areaCode = personnel.getAreaCode();
    this.streetCode = personnel.getStreetCode();
    this.provName = personnel.getProvName();
    this.cityName = personnel.getCityName();
    this.areaName = personnel.getAreaName();
    this.streetName = personnel.getStreetName();
    this.address = personnel.getAddress();
    this.creditCode = personnel.getCreditCode();
    this.corporation = personnel.getCorporation();
    this.agentId = personnel.getAgentId();
    this.agentName = personnel.getAgentName();
    this.agentSex = personnel.getAgentSex();
    this.agentPhone = personnel.getAgentPhone();
    this.agentIdCard = personnel.getAgentIdCard();
    this.userOrder = personnel.getUserOrder();
    this.email = personnel.getEmail();
    this.cardType = personnel.getCardType();
    this.agentCardType = personnel.getAgentCardType();
    this.nationality = personnel.getAgentNationality();
    this.agentNationality = personnel.getAgentNationality();
    this.nation = personnel.getNation();
    this.agentNation = personnel.getAgentNation();
    this.nationCode = personnel.getNationCode();
    this.nationName = personnel.getNationName();
  }

}
